/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.DirectInstantiator;
import org.gradle.internal.Factory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator
implements ServiceRegistry {
    private final ClassLoader classLoader;
    private final Map<Class<?>, Object> implementations = new ConcurrentHashMap();

    public ServiceLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> clazz) throws UnknownServiceException {
        Map<Class<?>, Object> map = this.implementations;
        synchronized (map) {
            T t = clazz.cast(this.implementations.get(clazz));
            if (t == null) {
                t = this.getFactory((Class)clazz).create();
                this.implementations.put(clazz, t);
            }
            return t;
        }
    }

    public <T> ServiceFactory<T> getFactory(Class<T> clazz) throws UnknownServiceException {
        ServiceFactory<T> serviceFactory = this.findFactory(clazz);
        if (serviceFactory == null) {
            throw new UnknownServiceException(clazz, String.format("Could not find meta-data resource 'META-INF/services/%s' for service '%s'.", clazz.getName(), clazz.getName()));
        }
        return serviceFactory;
    }

    public <T> ServiceFactory<T> findFactory(Class<T> clazz) {
        Class<T> clazz2 = this.findServiceImplementationClass(clazz);
        if (clazz2 == null) {
            return null;
        }
        return new ServiceFactory<T>(clazz, clazz2);
    }

    public <T> T newInstance(Class<T> clazz) throws UnknownServiceException {
        return this.getFactory((Class)clazz).create();
    }

    <T> Class<? extends T> findServiceImplementationClass(Class<T> clazz) {
        String string;
        try {
            string = this.findServiceImplementationClassName(clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Could not determine implementation class for service '%s'.", clazz.getName()), exception);
        }
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz2 = this.classLoader.loadClass(string);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new RuntimeException(String.format("Implementation class '%s' is not assignable to service class '%s'.", string, clazz.getName()));
            }
            return clazz2.asSubclass(clazz);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(String.format("Could not load implementation class '%s' for service '%s'.", string, clazz.getName()), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findServiceImplementationClassName(Class<?> clazz) throws IOException {
        String string = "META-INF/services/" + clazz.getName();
        URL uRL = this.classLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = uRL.openStream();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.replaceAll("#.*", "").trim()).length() <= 0) continue;
                String string3 = string2;
                return string3;
            }
        }
        finally {
            inputStream.close();
        }
        throw new RuntimeException(String.format("No implementation class for service '%s' specified in resource '%s'.", clazz.getName(), uRL));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceFactory<T>
    implements Factory<T> {
        private final Class<T> serviceType;
        private final Class<? extends T> implementationClass;

        public ServiceFactory(Class<T> clazz, Class<? extends T> clazz2) {
            this.serviceType = clazz;
            this.implementationClass = clazz2;
        }

        public Class<? extends T> getImplementationClass() {
            return this.implementationClass;
        }

        public T create() {
            return this.newInstance(new Object[0]);
        }

        public T newInstance(Object ... objectArray) {
            DirectInstantiator directInstantiator = new DirectInstantiator();
            try {
                return directInstantiator.newInstance(this.implementationClass, objectArray);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(String.format("Could not create an implementation of service '%s'.", this.serviceType.getName()), throwable);
            }
        }
    }
}

