/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Comparable<Path> {
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    private final String prefix;
    private final String[] segments;
    private final boolean absolute;
    public static final Path ROOT = new Path(":");

    public Path(String string) {
        assert (string.length() > 0);
        this.segments = StringUtils.split((String)string, (String)":");
        this.absolute = string.startsWith(":");
        this.prefix = string.endsWith(":") ? string : string + ":";
    }

    private Path(String[] stringArray, boolean bl) {
        this.segments = stringArray;
        this.absolute = bl;
        this.prefix = this.getPath() + ":";
    }

    public static Path path(String string) {
        return string.equals(":") ? ROOT : new Path(string);
    }

    public String toString() {
        return this.getPath();
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.absolute) {
            stringBuilder.append(":");
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                stringBuilder.append(":");
            }
            String string = this.segments[i];
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Path path = (Path)object;
        return Arrays.equals(this.segments, path.segments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    @Override
    public int compareTo(Path path) {
        int n;
        if (this.absolute && !path.absolute) {
            return 1;
        }
        if (!this.absolute && path.absolute) {
            return -1;
        }
        for (n = 0; n < Math.min(this.segments.length, path.segments.length); ++n) {
            int n2 = STRING_COMPARATOR.compare(this.segments[n], path.segments[n]);
            if (n2 == 0) continue;
            return n2;
        }
        n = this.segments.length - path.segments.length;
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        if (this.segments.length == 1) {
            return this.absolute ? ROOT : null;
        }
        String[] stringArray = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, stringArray, 0, stringArray.length);
        return new Path(stringArray, this.absolute);
    }

    public String getName() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public Path resolve(String string) {
        return new Path(this.absolutePath(string));
    }

    public String absolutePath(String string) {
        if (!this.isAbsolutePath(string)) {
            return this.prefix + string;
        }
        return string;
    }

    public String relativePath(String string) {
        if (string.startsWith(this.prefix) && string.length() > this.prefix.length()) {
            return string.substring(this.prefix.length());
        }
        return string;
    }

    private boolean isAbsolutePath(String string) {
        if (!GUtil.isTrue(string)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return string.startsWith(":");
    }
}

