/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameMatcher {
    private final SortedSet<String> matches = new TreeSet<String>();
    private final Set<String> candidates = new TreeSet<String>();
    private String pattern;

    public <T> T find(String string, Map<String, ? extends T> map) {
        String string2 = this.find(string, map.keySet());
        if (string2 != null) {
            return map.get(string2);
        }
        return null;
    }

    public String find(String string, Collection<String> collection) {
        this.pattern = string;
        this.matches.clear();
        this.candidates.clear();
        if (collection.contains(string)) {
            this.matches.add(string);
            return string;
        }
        if (string.length() == 0) {
            return null;
        }
        Pattern pattern = NameMatcher.getPatternForName(string);
        Pattern pattern2 = Pattern.compile(pattern.pattern(), 2);
        String string2 = string.toUpperCase();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        for (String string3 : collection) {
            if (string3.equalsIgnoreCase(string)) {
                treeSet.add(string3);
            }
            if (pattern.matcher(string3).matches()) {
                treeSet2.add(string3);
                continue;
            }
            if (pattern2.matcher(string3).lookingAt()) {
                treeSet3.add(string3);
                continue;
            }
            if (StringUtils.getLevenshteinDistance((String)string2, (String)string3.toUpperCase()) > Math.min(3, string.length() / 2)) continue;
            this.candidates.add(string3);
        }
        if (!treeSet.isEmpty()) {
            this.matches.addAll(treeSet);
        } else if (!treeSet2.isEmpty()) {
            this.matches.addAll(treeSet2);
        } else {
            this.matches.addAll(treeSet3);
        }
        if (this.matches.size() == 1) {
            return this.matches.first();
        }
        return null;
    }

    private static Pattern getPatternForName(String string) {
        Pattern pattern = Pattern.compile("((^|\\p{Punct})\\p{javaLowerCase}+)|(\\p{javaUpperCase}\\p{javaLowerCase}*)");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string2 = string.substring(n, matcher.start());
            if (string2.length() > 0) {
                stringBuilder.append(Pattern.quote(string2));
            }
            stringBuilder.append(Pattern.quote(matcher.group()));
            stringBuilder.append("[\\p{javaLowerCase}\\p{Digit}]*");
            n = matcher.end();
        }
        stringBuilder.append(Pattern.quote(string.substring(n, string.length())));
        return Pattern.compile(stringBuilder.toString());
    }

    public Set<String> getMatches() {
        return this.matches;
    }

    public Set<String> getCandidates() {
        return this.candidates;
    }

    public String formatErrorMessage(String string, Object object) {
        String string2 = StringUtils.capitalize((String)string);
        if (!this.matches.isEmpty()) {
            return String.format("%s '%s' is ambiguous in %s. Candidates are: %s.", string2, this.pattern, object, GUtil.toString(this.matches));
        }
        if (!this.candidates.isEmpty()) {
            return String.format("%s '%s' not found in %s. Some candidates are: %s.", string2, this.pattern, object, GUtil.toString(this.candidates));
        }
        return String.format("%s '%s' not found in %s.", string2, this.pattern, object);
    }
}

