/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.util.ClassLoaderBackedClasspathSource;
import org.gradle.util.ClasspathSource;
import org.gradle.util.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParentClassLoader
extends ClassLoader
implements ClasspathSource {
    private final List<ClassLoader> parents;
    private final JavaMethod<ClassLoader, Package[]> getPackagesMethod;
    private final JavaMethod<ClassLoader, Package> getPackageMethod;

    public MultiParentClassLoader(ClassLoader ... classLoaderArray) {
        super(null);
        this.parents = new CopyOnWriteArrayList<ClassLoader>(Arrays.asList(classLoaderArray));
        this.getPackagesMethod = JavaMethod.create(ClassLoader.class, Package[].class, "getPackages", new Class[0]);
        this.getPackageMethod = JavaMethod.create(ClassLoader.class, Package.class, "getPackage", String.class);
    }

    public void addParent(ClassLoader classLoader) {
        this.parents.add(classLoader);
    }

    @Override
    public void collectClasspath(Collection<? super URL> collection) {
        for (ClassLoader classLoader : this.parents) {
            new ClassLoaderBackedClasspathSource(classLoader).collectClasspath(collection);
        }
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.parents) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(String.format("%s not found.", string));
    }

    @Override
    protected Package getPackage(String string) {
        for (ClassLoader classLoader : this.parents) {
            Package package_ = this.getPackageMethod.invoke(classLoader, string);
            if (package_ == null) continue;
            return package_;
        }
        return null;
    }

    @Override
    protected Package[] getPackages() {
        LinkedHashSet<Package> linkedHashSet = new LinkedHashSet<Package>();
        for (ClassLoader classLoader : this.parents) {
            Package[] packageArray = this.getPackagesMethod.invoke(classLoader, new Object[0]);
            linkedHashSet.addAll(Arrays.asList(packageArray));
        }
        return linkedHashSet.toArray(new Package[linkedHashSet.size()]);
    }

    @Override
    public URL getResource(String string) {
        for (ClassLoader classLoader : this.parents) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        for (ClassLoader classLoader : this.parents) {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                linkedHashSet.add(enumeration.nextElement());
            }
        }
        return Collections.enumeration(linkedHashSet);
    }
}

