/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.gradle.api.Action;
import org.gradle.util.LineBufferingOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinePerThreadBufferingOutputStream
extends PrintStream {
    private final Action<String> listener;
    private final boolean includeEol;
    private final ThreadLocal<PrintStream> stream = new ThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return AccessController.doPrivileged(new PrivilegedAction<PrintStream>(){

                @Override
                public PrintStream run() {
                    return new PrintStream(new LineBufferingOutputStream(LinePerThreadBufferingOutputStream.this.listener, LinePerThreadBufferingOutputStream.this.includeEol));
                }
            });
        }
    };

    public LinePerThreadBufferingOutputStream(Action<String> action) {
        this(action, false);
    }

    public LinePerThreadBufferingOutputStream(Action<String> action, boolean bl) {
        super(new ByteArrayOutputStream(), true);
        this.listener = action;
        this.includeEol = bl;
    }

    private PrintStream getStream() {
        return this.stream.get();
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        this.getStream().append(charSequence);
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.getStream().append(c);
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence, int n, int n2) {
        this.getStream().append(charSequence, n, n2);
        return this;
    }

    @Override
    public boolean checkError() {
        return this.getStream().checkError();
    }

    @Override
    public void close() {
        this.getStream().close();
    }

    @Override
    public void flush() {
        this.getStream().flush();
    }

    @Override
    public PrintStream format(String string, Object ... objectArray) {
        this.getStream().format(string, objectArray);
        return this;
    }

    @Override
    public PrintStream format(Locale locale, String string, Object ... objectArray) {
        this.getStream().format(locale, string, objectArray);
        return this;
    }

    @Override
    public void print(boolean bl) {
        this.getStream().print(bl);
    }

    @Override
    public void print(char c) {
        this.getStream().print(c);
    }

    @Override
    public void print(double d) {
        this.getStream().print(d);
    }

    @Override
    public void print(float f) {
        this.getStream().print(f);
    }

    @Override
    public void print(int n) {
        this.getStream().print(n);
    }

    @Override
    public void print(long l) {
        this.getStream().print(l);
    }

    @Override
    public void print(Object object) {
        this.getStream().print(object);
    }

    @Override
    public void print(char[] cArray) {
        this.getStream().print(cArray);
    }

    @Override
    public void print(String string) {
        this.getStream().print(string);
    }

    @Override
    public PrintStream printf(String string, Object ... objectArray) {
        this.getStream().printf(string, objectArray);
        return this;
    }

    @Override
    public PrintStream printf(Locale locale, String string, Object ... objectArray) {
        this.getStream().printf(locale, string, objectArray);
        return this;
    }

    @Override
    public void println() {
        this.getStream().println();
    }

    @Override
    public void println(boolean bl) {
        this.getStream().println(bl);
    }

    @Override
    public void println(char c) {
        this.getStream().println(c);
    }

    @Override
    public void println(char[] cArray) {
        this.getStream().println(cArray);
    }

    @Override
    public void println(double d) {
        this.getStream().println(d);
    }

    @Override
    public void println(float f) {
        this.getStream().println(f);
    }

    @Override
    public void println(int n) {
        this.getStream().println(n);
    }

    @Override
    public void println(long l) {
        this.getStream().println(l);
    }

    @Override
    public void println(Object object) {
        this.getStream().println(object);
    }

    @Override
    public void println(String string) {
        this.getStream().println(string);
    }

    @Override
    public void write(int n) {
        this.getStream().write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.getStream().write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.getStream().write(byArray);
    }
}

