/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.internal.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineBufferingOutputStream
extends OutputStream {
    private boolean hasBeenClosed;
    private final byte[] lineSeparator;
    private final int bufferIncrement;
    private byte[] buf;
    private int count;
    private final Output output;

    public LineBufferingOutputStream(Action<String> action) {
        this(action, false, 2048);
    }

    public LineBufferingOutputStream(Action<String> action, boolean bl) {
        this(action, bl, 2048);
    }

    public LineBufferingOutputStream(Action<String> action, boolean bl, int n) {
        this(new StringOutput(bl, action), n);
    }

    private LineBufferingOutputStream(Output output, int n) {
        this.output = output;
        this.bufferIncrement = n;
        this.buf = new byte[n];
        this.count = 0;
        this.lineSeparator = SystemProperties.getLineSeparator().getBytes();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.hasBeenClosed = true;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (this.count == this.buf.length) {
            int n2 = this.buf.length + this.bufferIncrement;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n;
        ++this.count;
        if (this.endsWithLineSeparator()) {
            this.flush();
        }
    }

    private boolean endsWithLineSeparator() {
        if (this.count < this.lineSeparator.length) {
            return false;
        }
        for (int i = 0; i < this.lineSeparator.length; ++i) {
            if (this.buf[this.count - this.lineSeparator.length + i] == this.lineSeparator[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void flush() {
        if (this.count != 0) {
            int n = this.count;
            if (this.endsWithLineSeparator()) {
                n -= this.lineSeparator.length;
            }
            this.output.write(this.buf, n, this.count);
        }
        this.reset();
    }

    private void reset() {
        if (this.buf.length > this.bufferIncrement) {
            this.buf = new byte[this.bufferIncrement];
        }
        this.count = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringOutput
    implements Output {
        private final boolean includeEOL;
        private final Action<String> action;

        public StringOutput(boolean bl, Action<String> action) {
            this.includeEOL = bl;
            this.action = action;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            if (this.includeEOL) {
                this.action.execute(new String(byArray, 0, n2));
            } else {
                this.action.execute(new String(byArray, 0, n));
            }
        }
    }

    private static interface Output {
        public void write(byte[] var1, int var2, int var3);
    }
}

