/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.gradle.api.GradleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod<T, R> {
    private final Method method;
    private final Class<R> returnType;

    private JavaMethod(Class<T> clazz, Class<R> clazz2, String string, Class<?> ... classArray) {
        this.returnType = clazz2;
        this.method = this.findMethod(clazz, string, classArray);
        this.method.setAccessible(true);
    }

    private JavaMethod(Class<T> clazz, Class<R> clazz2, Method method) {
        this.returnType = clazz2;
        this.method = method;
        method.setAccessible(true);
    }

    private Method findMethod(Class clazz, String string, Class<?>[] classArray) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getName().equals(string) || !Arrays.equals(method.getParameterTypes(), classArray)) continue;
            return method;
        }
        throw new GradleException(String.format("Could not find method %s(%s) on %s", string, Arrays.toString(classArray), clazz));
    }

    public R invoke(T t, Object ... objectArray) {
        try {
            return this.returnType.cast(this.method.invoke(t, objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), t), throwable);
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), t), exception);
        }
    }

    public static <T, R> JavaMethod<T, R> create(Class<T> clazz, Class<R> clazz2, String string, Class<?> ... classArray) {
        return new JavaMethod<T, R>(clazz, clazz2, string, classArray);
    }

    public static <T, R> JavaMethod<T, R> create(Class<T> clazz, Class<R> clazz2, Method method) {
        return new JavaMethod<T, R>(clazz, clazz2, method);
    }
}

