/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import groovy.lang.GroovySystem;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ivy.Ivy;
import org.apache.tools.ant.Main;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleVersion
implements Comparable<GradleVersion> {
    public static final String URL = "http://www.gradle.org";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)+)(-(\\p{Alpha}+)-(\\d+[a-z]?))?(-(\\d{14}[-+]\\d{4}))?");
    private final String version;
    private final String buildTime;
    private final Long snapshot;
    private final String versionPart;
    private final Stage stage;
    private static final GradleVersion CURRENT;
    public static final String RESOURCE_NAME = "/org/gradle/releases.xml";

    public static GradleVersion current() {
        return CURRENT;
    }

    public static GradleVersion version(String string) {
        return new GradleVersion(string, null);
    }

    private GradleVersion(String string, Date date) {
        this.version = string;
        this.buildTime = date == null ? null : this.formatBuildTime(date);
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new InvalidUserDataException(String.format("Unexpected Gradle version '%s'.", string));
        }
        this.versionPart = matcher.group(1);
        if (matcher.group(3) != null) {
            int n = 0;
            if (matcher.group(4).equals("milestone")) {
                n = 1;
            } else if (matcher.group(4).equals("preview")) {
                n = 2;
            } else if (matcher.group(4).equals("rc")) {
                n = 3;
            }
            String string2 = matcher.group(5);
            this.stage = new Stage(n, string2);
        } else {
            this.stage = null;
        }
        if (matcher.group(7) != null) {
            try {
                this.snapshot = new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(7)).getTime();
            }
            catch (ParseException parseException) {
                throw UncheckedException.throwAsUncheckedException((Throwable)parseException);
            }
        } else {
            this.snapshot = null;
        }
    }

    private String formatBuildTime(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public String toString() {
        return String.format("Gradle %s", this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public int compareTo(GradleVersion gradleVersion) {
        int n;
        String[] stringArray = this.versionPart.split("\\.");
        String[] stringArray2 = gradleVersion.versionPart.split("\\.");
        for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
            int n2;
            int n3 = Integer.parseInt(stringArray[n]);
            if (n3 > (n2 = Integer.parseInt(stringArray2[n]))) {
                return 1;
            }
            if (n2 <= n3) continue;
            return -1;
        }
        if (stringArray.length > stringArray2.length) {
            return 1;
        }
        if (stringArray.length < stringArray2.length) {
            return -1;
        }
        if (this.stage != null && gradleVersion.stage != null && (n = this.stage.compareTo(gradleVersion.stage)) != 0) {
            return n;
        }
        if (this.stage == null && gradleVersion.stage != null) {
            return 1;
        }
        if (this.stage != null && gradleVersion.stage == null) {
            return -1;
        }
        if (this.snapshot != null && gradleVersion.snapshot != null) {
            return this.snapshot.compareTo(gradleVersion.snapshot);
        }
        if (this.snapshot == null && gradleVersion.snapshot != null) {
            return 1;
        }
        if (this.snapshot != null && gradleVersion.snapshot == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        GradleVersion gradleVersion = (GradleVersion)object;
        return this.version.equals(gradleVersion.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n------------------------------------------------------------\nGradle ");
        stringBuilder.append(this.getVersion());
        stringBuilder.append("\n------------------------------------------------------------\n\nGradle build time: ");
        stringBuilder.append(this.getBuildTime());
        stringBuilder.append("\nGroovy: ");
        stringBuilder.append(GroovySystem.getVersion());
        stringBuilder.append("\nAnt: ");
        stringBuilder.append(Main.getAntVersion());
        stringBuilder.append("\nIvy: ");
        stringBuilder.append(Ivy.getIvyVersion());
        stringBuilder.append("\nJVM: ");
        stringBuilder.append(Jvm.current());
        stringBuilder.append("\nOS: ");
        stringBuilder.append(OperatingSystem.current());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        URL uRL = GradleVersion.class.getResource(RESOURCE_NAME);
        try {
            Document document;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStream inputStream = uRL.openStream();
            try {
                document = documentBuilder.parse(inputStream);
            }
            finally {
                inputStream.close();
            }
            NodeList nodeList = document.getDocumentElement().getElementsByTagName("current");
            if (nodeList.getLength() != 1) {
                throw new GradleException(String.format("Expected to find 1 <current> element, found %s.", nodeList.getLength()));
            }
            Element element = (Element)nodeList.item(0);
            CURRENT = new GradleVersion(element.getAttribute("version"), new SimpleDateFormat("yyyyMMddHHmmssZ").parse(element.getAttribute("build-time")));
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not load version details from resource '%s'.", uRL), exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;
        final Character patchNo;

        Stage(int n, String string) {
            this.stage = n;
            Matcher matcher = Pattern.compile("(\\d+)([a-z])?").matcher(string);
            try {
                matcher.matches();
                this.number = Integer.parseInt(matcher.group(1));
            }
            catch (Exception exception) {
                throw new RuntimeException("Invalid stage small number: " + string, exception);
            }
            this.patchNo = matcher.groupCount() == 2 && matcher.group(2) != null ? Character.valueOf(matcher.group(2).charAt(0)) : Character.valueOf('_');
        }

        @Override
        public int compareTo(Stage stage) {
            if (this.stage > stage.stage) {
                return 1;
            }
            if (this.stage < stage.stage) {
                return -1;
            }
            if (this.number > stage.number) {
                return 1;
            }
            if (this.number < stage.number) {
                return -1;
            }
            if (this.patchNo.charValue() > stage.patchNo.charValue()) {
                return 1;
            }
            if (this.patchNo.charValue() < stage.patchNo.charValue()) {
                return -1;
            }
            return 0;
        }
    }
}

