/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.UncheckedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUtil {
    public static <T extends Collection> T flatten(Object[] objectArray, T t, boolean bl) {
        return GUtil.flatten(Arrays.asList(objectArray), t, bl);
    }

    public static <T extends Collection> T flatten(Object[] objectArray, T t) {
        return GUtil.flatten(Arrays.asList(objectArray), t);
    }

    public static <T extends Collection> T flatten(Collection collection, T t) {
        return GUtil.flatten(collection, t, true);
    }

    public static <T extends Collection> T flattenElements(Object ... objectArray) {
        LinkedList linkedList = new LinkedList();
        GUtil.flatten(objectArray, linkedList, true);
        return (T)linkedList;
    }

    public static <T extends Collection> T flatten(Collection collection, T t, boolean bl) {
        return GUtil.flatten(collection, t, bl, bl);
    }

    public static <T extends Collection> T flatten(Collection collection, T t, boolean bl, boolean bl2) {
        for (Object e : collection) {
            if (e instanceof Collection) {
                GUtil.flatten((Collection)e, t, bl, bl2);
                continue;
            }
            if (e instanceof Map && bl) {
                GUtil.flatten(((Map)e).values(), t, bl, bl2);
                continue;
            }
            if (e.getClass().isArray() && bl2) {
                GUtil.flatten(Arrays.asList((Object[])e), t, bl, bl2);
                continue;
            }
            t.add(e);
        }
        return t;
    }

    public static Collection collectionize(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            LinkedList linkedList = new LinkedList();
            GUtil.flatten((Collection)object, linkedList, false, true);
            return linkedList;
        }
        if (object.getClass().isArray()) {
            LinkedList linkedList = new LinkedList();
            GUtil.flatten(Arrays.asList((Object[])object), linkedList, false, true);
            return linkedList;
        }
        return Arrays.asList(object);
    }

    public static List flatten(Collection collection, boolean bl) {
        return GUtil.flatten(collection, new ArrayList(), bl);
    }

    public static List flatten(Collection collection) {
        return GUtil.flatten(collection, new ArrayList());
    }

    public static String join(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (string == null) {
            string = "";
        }
        for (Object e : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(e.toString());
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        return GUtil.join(Arrays.asList(objectArray), string);
    }

    public static List<String> prefix(String string, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            arrayList.add(string + string2);
        }
        return arrayList;
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        return true;
    }

    public static <T> T elvis(T t, T t2) {
        return GUtil.isTrue(t) ? t : t2;
    }

    public static <V, T extends Collection<? super V>> T addToCollection(T t, Iterable<? extends V> ... iterableArray) {
        for (Iterable<V> iterable : iterableArray) {
            for (V v : iterable) {
                t.add(v);
            }
        }
        return t;
    }

    public static Comparator<String> caseInsensitive() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = string.compareToIgnoreCase(string2);
                if (n != 0) {
                    return n;
                }
                return string.compareTo(string2);
            }
        };
    }

    public static Map addMaps(Map map, Map map2) {
        HashMap hashMap = new HashMap();
        hashMap.putAll(map);
        hashMap.putAll(map2);
        return hashMap;
    }

    public static void addToMap(Map<String, String> map, Map<?, ?> map2) {
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        Properties properties;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties = GUtil.loadProperties(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        fileInputStream.close();
        return properties;
    }

    public static Properties loadProperties(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            return GUtil.loadProperties(uRLConnection.getInputStream());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Properties properties, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                properties.store(fileOutputStream, null);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static Map map(Object ... objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        assert (objectArray.length % 2 == 0);
        for (int i = 0; i < objectArray.length; i += 2) {
            hashMap.put(objectArray[i], objectArray[i + 1]);
        }
        return hashMap;
    }

    public static String toString(Iterable<?> iterable) {
        Formatter formatter = new Formatter();
        boolean bl = true;
        for (Object obj : iterable) {
            if (bl) {
                formatter.format("'%s'", obj);
                bl = false;
                continue;
            }
            formatter.format(", '%s'", obj);
        }
        return formatter.toString();
    }

    public static String toCamelCase(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = Pattern.compile("[^\\w]+").matcher(charSequence);
        int n = 0;
        while (matcher.find()) {
            stringBuilder.append(StringUtils.capitalize((String)charSequence.subSequence(n, matcher.start()).toString()));
            n = matcher.end();
        }
        stringBuilder.append(StringUtils.capitalize((String)charSequence.subSequence(n, charSequence.length()).toString()));
        return stringBuilder.toString();
    }

    public static String toConstant(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return GUtil.toWords(charSequence, '_').toUpperCase();
    }

    public static String toWords(CharSequence charSequence) {
        return GUtil.toWords(charSequence, ' ');
    }

    public static String toWords(CharSequence charSequence, char c) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Matcher matcher = Pattern.compile("(\\p{Upper}*)(\\p{Lower}*)").matcher(charSequence);
        while (n < charSequence.length()) {
            matcher.find(n);
            if (matcher.end() == n) {
                ++n;
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(c);
            }
            String string = matcher.group(1).toLowerCase();
            String string2 = matcher.group(2);
            if (string2.length() == 0) {
                stringBuilder.append(string);
            } else {
                if (string.length() > 1) {
                    stringBuilder.append(string.substring(0, string.length() - 1));
                    stringBuilder.append(c);
                    stringBuilder.append(string.substring(string.length() - 1));
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
            }
            n = matcher.end();
        }
        return stringBuilder.toString();
    }

    public static byte[] serialize(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> Comparator<T> last(final Comparator<? super T> comparator, final T t) {
        return new Comparator<T>(){

            @Override
            public int compare(T t3, T t2) {
                boolean bl;
                boolean bl2 = comparator.compare(t3, t) == 0;
                boolean bl3 = bl = comparator.compare(t2, t) == 0;
                if (bl2 && bl) {
                    return 0;
                }
                if (bl2 && !bl) {
                    return 1;
                }
                if (!bl2 && bl) {
                    return -1;
                }
                return comparator.compare(t3, t2);
            }
        };
    }
}

