/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.internal.LimitedDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFileUtils {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static FileInputStream openInputStream(File file) {
        try {
            return FileUtils.openInputStream((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static FileOutputStream openOutputStream(File file) {
        try {
            return FileUtils.openOutputStream((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static String byteCountToDisplaySize(long l) {
        return FileUtils.byteCountToDisplaySize((long)l);
    }

    public static void touch(File file) {
        try {
            FileUtils.touch((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection collection) {
        return FileUtils.convertFileCollectionToFileArray((Collection)collection);
    }

    public static Collection listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles((File)file, (IOFileFilter)iOFileFilter, (IOFileFilter)iOFileFilter2);
    }

    public static Iterator iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.iterateFiles((File)file, (IOFileFilter)iOFileFilter, (IOFileFilter)iOFileFilter2);
    }

    public static Collection listFiles(File file, String[] stringArray, boolean bl) {
        return FileUtils.listFiles((File)file, (String[])stringArray, (boolean)bl);
    }

    public static Iterator iterateFiles(File file, String[] stringArray, boolean bl) {
        return FileUtils.iterateFiles((File)file, (String[])stringArray, (boolean)bl);
    }

    public static boolean contentEquals(File file, File file2) {
        try {
            return FileUtils.contentEquals((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static File toFile(String ... stringArray) {
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < stringArray.length; ++i) {
            stringWriter.write(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringWriter.write(FILE_SEPARATOR);
        }
        return new File(stringWriter.toString());
    }

    public static File toFile(URL uRL) {
        return FileUtils.toFile((URL)uRL);
    }

    public static File[] toFiles(URL[] uRLArray) {
        return FileUtils.toFiles((URL[])uRLArray);
    }

    public static List<String> toPaths(Collection<File> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : collection) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    public static List<URI> toURIs(Iterable<File> iterable) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (File file : iterable) {
            arrayList.add(file.toURI());
        }
        return arrayList;
    }

    public static List<URL> toURLs(Iterable<File> iterable) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : iterable) {
            try {
                arrayList.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new UncheckedIOException(malformedURLException);
            }
        }
        return arrayList;
    }

    public static List<URL> urisToUrls(Iterable<URI> iterable) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URI uRI : iterable) {
            try {
                arrayList.add(uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new UncheckedIOException(malformedURLException);
            }
        }
        return arrayList;
    }

    public static URL[] toURLArray(Collection<File> collection) {
        return GFileUtils.toURLs(collection.toArray(new File[collection.size()]));
    }

    public static URL[] toURLs(File[] fileArray) {
        try {
            URL[] uRLArray = new URL[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                uRLArray[i] = file.toURI().toURL();
            }
            return uRLArray;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyFileToDirectory(File file, File file2) {
        try {
            FileUtils.copyFileToDirectory((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl) {
        try {
            FileUtils.copyFileToDirectory((File)file, (File)file2, (boolean)bl);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyFile(File file, File file2) {
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyFile(File file, File file2, boolean bl) {
        try {
            FileUtils.copyFile((File)file, (File)file2, (boolean)bl);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyDirectoryToDirectory(File file, File file2) {
        try {
            FileUtils.copyDirectoryToDirectory((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyDirectory(File file, File file2) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyDirectory(File file, File file2, boolean bl) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2, (boolean)bl);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2, (FileFilter)fileFilter);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2, (FileFilter)fileFilter, (boolean)bl);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copyURLToFile(URL uRL, File file) {
        try {
            FileUtils.copyURLToFile((URL)uRL, (File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void deleteDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static boolean deleteQuietly(File file) {
        return FileUtils.deleteQuietly((File)file);
    }

    public static void cleanDirectory(File file) {
        try {
            FileUtils.cleanDirectory((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static boolean waitFor(File file, int n) {
        return FileUtils.waitFor((File)file, (int)n);
    }

    public static String readFileToString(File file, String string) {
        try {
            return FileUtils.readFileToString((File)file, (String)string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static String readFileToString(File file) {
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static byte[] readFileToByteArray(File file) {
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static List readLines(File file, String string) {
        try {
            return FileUtils.readLines((File)file, (String)string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static List readLines(File file) {
        try {
            return FileUtils.readLines((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static String tail(File file, int n) throws TailReadingException {
        String string;
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            LimitedDescription limitedDescription = new LimitedDescription(n);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                limitedDescription.append(string2);
                string2 = bufferedReader.readLine();
            }
            string = limitedDescription.toString();
        }
        catch (Exception exception) {
            try {
                throw new TailReadingException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        IOUtils.closeQuietly((Reader)bufferedReader);
        return string;
    }

    public static LineIterator lineIterator(File file, String string) {
        try {
            return FileUtils.lineIterator((File)file, (String)string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static LineIterator lineIterator(File file) {
        try {
            return FileUtils.lineIterator((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeStringToFile(File file, String string, String string2) {
        try {
            FileUtils.writeStringToFile((File)file, (String)string, (String)string2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeStringToFile(File file, String string) {
        try {
            FileUtils.writeStringToFile((File)file, (String)string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeLines(File file, String string, Collection collection) {
        try {
            FileUtils.writeLines((File)file, (String)string, (Collection)collection);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeLines(File file, Collection collection) {
        try {
            FileUtils.writeLines((File)file, (Collection)collection);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeLines(File file, String string, Collection collection, String string2) {
        try {
            FileUtils.writeLines((File)file, (String)string, (Collection)collection, (String)string2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeLines(File file, Collection collection, String string) {
        try {
            FileUtils.writeLines((File)file, (Collection)collection, (String)string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void forceDelete(File file) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void forceDeleteOnExit(File file) {
        try {
            FileUtils.forceDeleteOnExit((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void forceMkdir(File file) {
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static long sizeOfDirectory(File file) {
        return FileUtils.sizeOfDirectory((File)file);
    }

    public static boolean isFileNewer(File file, File file2) {
        return FileUtils.isFileNewer((File)file, (File)file2);
    }

    public static boolean isFileNewer(File file, Date date) {
        return FileUtils.isFileNewer((File)file, (Date)date);
    }

    public static boolean isFileNewer(File file, long l) {
        return FileUtils.isFileNewer((File)file, (long)l);
    }

    public static boolean isFileOlder(File file, File file2) {
        return FileUtils.isFileOlder((File)file, (File)file2);
    }

    public static boolean isFileOlder(File file, Date date) {
        return FileUtils.isFileOlder((File)file, (Date)date);
    }

    public static boolean isFileOlder(File file, long l) {
        return FileUtils.isFileOlder((File)file, (long)l);
    }

    public static long checksumCRC32(File file) {
        try {
            return FileUtils.checksumCRC32((File)file);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static Checksum checksum(File file, Checksum checksum) {
        try {
            return FileUtils.checksum((File)file, (Checksum)checksum);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void moveDirectory(File file, File file2) {
        try {
            FileUtils.moveDirectory((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void moveDirectoryToDirectory(File file, File file2, boolean bl) {
        try {
            FileUtils.moveDirectoryToDirectory((File)file, (File)file2, (boolean)bl);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void moveFile(File file, File file2) {
        try {
            FileUtils.moveFile((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void moveFileToDirectory(File file, File file2, boolean bl) {
        try {
            FileUtils.moveFileToDirectory((File)file, (File)file2, (boolean)bl);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void moveToDirectory(File file, File file2, boolean bl) {
        try {
            FileUtils.moveToDirectory((File)file, (File)file2, (boolean)bl);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static File canonicalise(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static List<File> getSubDirectories(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        GFileUtils.addSubDirectories(file, arrayList);
        return arrayList;
    }

    public static void addSubDirectories(File file, Collection<File> collection) {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                collection.add(file2);
                GFileUtils.addSubDirectories(file2, collection);
            }
        }
    }

    public static List<File> getSubFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (!file2.isFile()) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public static boolean createDirectoriesWhenNotExistent(File ... fileArray) {
        if (fileArray != null && fileArray.length > 0) {
            boolean bl = true;
            for (int i = 0; bl && i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (file.exists()) continue;
                bl = file.mkdirs();
            }
            return bl;
        }
        return true;
    }

    public static void createDirectory(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new UncheckedIOException("Failed to create directory " + file);
        }
    }

    public static class TailReadingException
    extends RuntimeException {
        public TailReadingException(Throwable throwable) {
            super(throwable);
        }
    }
}

