/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.gradle.util.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringClassLoader
extends ClassLoader {
    private static final Set<ClassLoader> SYSTEM_CLASS_LOADERS;
    private static final ClassLoader EXT_CLASS_LOADER;
    private static final Set<String> SYSTEM_PACKAGES;
    private final Set<String> packageNames = new HashSet<String>();
    private final Set<String> packagePrefixes = new HashSet<String>();
    private final Set<String> resourcePrefixes = new HashSet<String>();
    private final Set<String> resourceNames = new HashSet<String>();
    private final Set<String> classNames = new HashSet<String>();

    public FilteringClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = super.loadClass(string, false);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (this.classAllowed(string)) {
                throw noClassDefFoundError;
            }
            throw new ClassNotFoundException(String.format("%s not found.", string));
        }
        if (!this.allowed(clazz)) {
            throw new ClassNotFoundException(String.format("%s not found.", clazz.getName()));
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Package getPackage(String string) {
        Package package_ = super.getPackage(string);
        if (package_ == null || !this.allowed(package_)) {
            return null;
        }
        return package_;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        for (Package package_ : super.getPackages()) {
            if (!this.allowed(package_)) continue;
            arrayList.add(package_);
        }
        return arrayList.toArray(new Package[arrayList.size()]);
    }

    @Override
    public URL getResource(String string) {
        if (this.allowed(string)) {
            return super.getResource(string);
        }
        return EXT_CLASS_LOADER.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        if (this.allowed(string)) {
            return super.getResources(string);
        }
        return EXT_CLASS_LOADER.getResources(string);
    }

    private boolean allowed(String string) {
        if (this.resourceNames.contains(string)) {
            return true;
        }
        for (String string2 : this.resourcePrefixes) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(Package package_) {
        if (SYSTEM_PACKAGES.contains(package_.getName())) {
            return true;
        }
        if (this.packageNames.contains(package_.getName())) {
            return true;
        }
        for (String string : this.packagePrefixes) {
            if (!package_.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(final Class<?> clazz) {
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return clazz.getClassLoader() == null || SYSTEM_CLASS_LOADERS.contains(clazz.getClassLoader());
            }
        });
        return bl || this.classAllowed(clazz.getName());
    }

    private boolean classAllowed(String string) {
        if (this.classNames.contains(string)) {
            return true;
        }
        for (String string2 : this.packagePrefixes) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public void allowPackage(String string) {
        this.packageNames.add(string);
        this.packagePrefixes.add(string + ".");
        this.resourcePrefixes.add(string.replace('.', '/') + '/');
    }

    public void allowClass(Class<?> clazz) {
        this.classNames.add(clazz.getName());
    }

    public void allowResources(String string) {
        this.resourcePrefixes.add(string + "/");
    }

    public void allowResource(String string) {
        this.resourceNames.add(string);
    }

    static {
        Package[] packageArray;
        Object object;
        SYSTEM_CLASS_LOADERS = new HashSet<ClassLoader>();
        SYSTEM_PACKAGES = new HashSet<String>();
        EXT_CLASS_LOADER = ClassLoader.getSystemClassLoader().getParent();
        for (object = EXT_CLASS_LOADER; object != null; object = ((ClassLoader)object).getParent()) {
            SYSTEM_CLASS_LOADERS.add((ClassLoader)object);
        }
        object = JavaMethod.create(ClassLoader.class, Package[].class, "getPackages", new Class[0]);
        for (Package package_ : packageArray = (Package[])((JavaMethod)object).invoke(EXT_CLASS_LOADER, new Object[0])) {
            SYSTEM_PACKAGES.add(package_.getName());
        }
    }
}

