/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GradleVersion;

public class DistributionLocator {
    private static final String RELEASE_REPOSITORY = "http://services.gradle.org/distributions";
    private static final String SNAPSHOT_REPOSITORY = "http://services.gradle.org/distributions-snapshots";

    public URI getDistributionFor(GradleVersion gradleVersion) {
        return this.getDistribution(this.getDistributionRepository(gradleVersion), gradleVersion, "gradle", "bin");
    }

    private String getDistributionRepository(GradleVersion gradleVersion) {
        if (gradleVersion.isSnapshot()) {
            return SNAPSHOT_REPOSITORY;
        }
        return RELEASE_REPOSITORY;
    }

    private URI getDistribution(String string, GradleVersion gradleVersion, String string2, String string3) {
        try {
            return new URI(String.format("%s/%s-%s-%s.zip", string, string2, gradleVersion.getVersion(), string3));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)uRISyntaxException);
        }
    }
}

