/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.util.BulkReadInputStream;

public class DisconnectableInputStream
extends BulkReadInputStream {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final byte[] buffer;
    private int readPos;
    private int writePos;
    private boolean closed;
    private boolean inputFinished;

    public DisconnectableInputStream(InputStream inputStream, ExecutorFactory executorFactory) {
        this(inputStream, executorFactory, 1024);
    }

    public DisconnectableInputStream(final InputStream inputStream, ExecutorFactory executorFactory, int n) {
        this.buffer = new byte[n];
        executorFactory.create("read input").execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (true) {
                        int n;
                        DisconnectableInputStream.this.lock.lock();
                        try {
                            while (!DisconnectableInputStream.this.closed && DisconnectableInputStream.this.writePos == DisconnectableInputStream.this.buffer.length && DisconnectableInputStream.this.writePos != DisconnectableInputStream.this.readPos) {
                                DisconnectableInputStream.this.condition.await();
                            }
                            assert (DisconnectableInputStream.this.writePos >= DisconnectableInputStream.this.readPos);
                            if (DisconnectableInputStream.this.closed) {
                                DisconnectableInputStream.this.inputFinished = true;
                                DisconnectableInputStream.this.condition.signalAll();
                                return;
                            }
                            if (DisconnectableInputStream.this.readPos == DisconnectableInputStream.this.writePos) {
                                DisconnectableInputStream.this.readPos = 0;
                                DisconnectableInputStream.this.writePos = 0;
                            }
                            n = DisconnectableInputStream.this.writePos;
                        }
                        finally {
                            DisconnectableInputStream.this.lock.unlock();
                        }
                        int n2 = inputStream.read(DisconnectableInputStream.this.buffer, n, DisconnectableInputStream.this.buffer.length - n);
                        DisconnectableInputStream.this.lock.lock();
                        try {
                            if (n2 > 0) {
                                assert (DisconnectableInputStream.this.writePos >= DisconnectableInputStream.this.readPos);
                                DisconnectableInputStream.this.writePos += n2;
                                assert (DisconnectableInputStream.this.buffer.length >= DisconnectableInputStream.this.writePos);
                                DisconnectableInputStream.this.condition.signalAll();
                            }
                            if (!DisconnectableInputStream.this.closed && n2 >= 0) continue;
                            DisconnectableInputStream.this.inputFinished = true;
                            DisconnectableInputStream.this.condition.signalAll();
                            return;
                        }
                        finally {
                            DisconnectableInputStream.this.lock.unlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    DisconnectableInputStream.this.lock.lock();
                    try {
                        DisconnectableInputStream.this.inputFinished = true;
                        DisconnectableInputStream.this.condition.signalAll();
                    }
                    finally {
                        DisconnectableInputStream.this.lock.unlock();
                    }
                    throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
                }
            }
        });
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.lock.lock();
        try {
            while (!this.inputFinished && !this.closed && this.readPos == this.writePos) {
                this.condition.await();
            }
            if (this.inputFinished && this.readPos == this.writePos) {
                int n4 = -1;
                return n4;
            }
            if (this.closed) {
                int n5 = -1;
                return n5;
            }
            assert (this.writePos > this.readPos);
            n3 = Math.min(n2, this.writePos - this.readPos);
            System.arraycopy(this.buffer, this.readPos, byArray, n, n3);
            this.readPos += n3;
            assert (this.writePos >= this.readPos);
            this.condition.signalAll();
        }
        catch (InterruptedException interruptedException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
        }
        finally {
            this.lock.unlock();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.closed = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

