/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.internal.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecationLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecationLogger.class);
    private static final Set<String> PLUGINS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> TASKS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> METHODS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> DYNAMIC_PROPERTIES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> PROPERTIES = Collections.synchronizedSet(new HashSet());
    private static final Set<String> NAMED_PARAMETERS = Collections.synchronizedSet(new HashSet());
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static final ThreadLocal<Boolean> LOG_TRACE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public static final String ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME = "org.gradle.deprecation.trace";

    public static void reset() {
        PLUGINS.clear();
        METHODS.clear();
        PROPERTIES.clear();
        NAMED_PARAMETERS.clear();
        DYNAMIC_PROPERTIES.clear();
    }

    public static void nagUserOfReplacedPlugin(String string, String string2) {
        if (DeprecationLogger.isEnabled() && PLUGINS.add(string)) {
            LOGGER.warn(String.format("The %s plugin has been deprecated and will be removed in the next version of Gradle. Please use the %s plugin instead.", string, string2));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedTask(String string, String string2) {
        if (DeprecationLogger.isEnabled() && TASKS.add(string)) {
            LOGGER.warn(String.format("The %s task has been deprecated and will be removed in the next version of Gradle. Please use the %s instead.", string, string2));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedMethod(String string, String string2) {
        if (DeprecationLogger.isEnabled() && METHODS.add(string)) {
            LOGGER.warn(String.format("The %s method has been deprecated and will be removed in the next version of Gradle. Please use the %s method instead.", string, string2));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedProperty(String string, String string2) {
        if (DeprecationLogger.isEnabled() && PROPERTIES.add(string)) {
            LOGGER.warn(String.format("The %s property has been deprecated and will be removed in the next version of Gradle. Please use the %s property instead.", string, string2));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDiscontinuedMethod(String string) {
        if (DeprecationLogger.isEnabled() && METHODS.add(string)) {
            LOGGER.warn(String.format("The %s method has been deprecated and will be removed in the next version of Gradle.", string));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfDiscontinuedProperty(String string, String string2) {
        if (DeprecationLogger.isEnabled() && PROPERTIES.add(string)) {
            LOGGER.warn(String.format("The %s property has been deprecated and will be removed in the next version of Gradle. %s", string, string2));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserOfReplacedNamedParameter(String string, String string2) {
        if (DeprecationLogger.isEnabled() && NAMED_PARAMETERS.add(string)) {
            LOGGER.warn(String.format("The %s named parameter has been deprecated and will be removed in the next version of Gradle. Please use the %s named parameter instead.", string, string2));
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    public static void nagUserWith(String string) {
        if (DeprecationLogger.isEnabled() && METHODS.add(string)) {
            LOGGER.warn(string);
            DeprecationLogger.logTraceIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isTraceLoggingEnabled() {
        return Boolean.getBoolean(ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME) || LOG_TRACE.get() != false;
    }

    private static void logTraceIfNecessary() {
        if (DeprecationLogger.isTraceLoggingEnabled()) {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = StackTraceUtils.sanitize((Throwable)new Exception()).getStackTrace()) {
                if (stackTraceElement.getClassName().startsWith(DeprecationLogger.class.getName())) continue;
                LOGGER.warn("    {}", (Object)stackTraceElement.toString());
            }
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void setLogTrace(boolean bl) {
        LOG_TRACE.set(bl);
    }

    public static void nagUserAboutDynamicProperty(String string, Object object, Object object2) {
        if (!DeprecationLogger.isEnabled()) {
            return;
        }
        DeprecationLogger.nagUserWith("Dynamic properties are deprecated: http://gradle.org/docs/current/dsl/org.gradle.api.plugins.ExtraPropertiesExtension.html");
        String string2 = object.getClass().getName() + "." + string;
        if (DYNAMIC_PROPERTIES.add(string2)) {
            String string3 = String.format("\"%s\" on \"%s\"", string, object);
            String string4 = object2 == null ? "null" : StringUtils.abbreviate((String)object2.toString(), (int)25);
            DeprecationLogger.nagUserWith(String.format("Deprecated dynamic property: %s, value: \"%s\".", string3, string4));
        } else {
            DeprecationLogger.nagUserWith(String.format("Deprecated dynamic property \"%s\" created in multiple locations.", string));
        }
    }
}

