/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.util.ClassPath;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassPath
implements ClassPath,
Serializable {
    private final List<File> files = new ArrayList<File>();

    public DefaultClassPath(Iterable<File> iterable) {
        for (File file : iterable) {
            this.files.add(file);
        }
    }

    public DefaultClassPath(File ... fileArray) {
        this(Arrays.asList(fileArray));
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    public Collection<URI> getAsURIs() {
        return GFileUtils.toURIs(this.files);
    }

    @Override
    public Collection<File> getAsFiles() {
        return this.files;
    }

    @Override
    public URL[] getAsURLArray() {
        return GFileUtils.toURLArray(this.files);
    }

    @Override
    public Collection<URL> getAsURLs() {
        return GFileUtils.toURLs(this.files);
    }

    @Override
    public ClassPath plus(ClassPath classPath) {
        if (this.files.isEmpty()) {
            return classPath;
        }
        if (classPath.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, classPath.getAsFiles()));
    }

    @Override
    public ClassPath plus(Collection<File> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, collection));
    }

    private Iterable<File> concat(List<File> list, Collection<File> collection) {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.addAll(list);
        arrayList.addAll(collection);
        return arrayList;
    }
}

