/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.util.ClassLoaderFactory;
import org.gradle.util.ClassPath;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.FilteringClassLoader;
import org.gradle.util.GFileUtils;
import org.gradle.util.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderFactory
implements ClassLoaderFactory {
    @Override
    public ClassLoader createIsolatedClassLoader(ClassPath classPath) {
        return this.createIsolatedClassLoader(classPath.getAsURIs());
    }

    @Override
    public ClassLoader createIsolatedClassLoader(Iterable<URI> iterable) {
        List<URL> list = GFileUtils.urisToUrls(iterable);
        if (this.needJaxpImpl()) {
            try {
                list.add(ClasspathUtil.getClasspathForResource(ClassLoader.getSystemClassLoader(), "META-INF/services/javax.xml.parsers.SAXParserFactory").toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw UncheckedException.throwAsUncheckedException((Throwable)malformedURLException);
            }
        }
        return new URLClassLoader(list.toArray(new URL[list.size()]), ClassLoader.getSystemClassLoader().getParent());
    }

    @Override
    public FilteringClassLoader createFilteringClassLoader(ClassLoader classLoader) {
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(classLoader);
        if (this.needJaxpImpl()) {
            ServiceLocator serviceLocator = new ServiceLocator(ClassLoader.getSystemClassLoader());
            this.makeServiceVisible(serviceLocator, filteringClassLoader, SAXParserFactory.class);
            this.makeServiceVisible(serviceLocator, filteringClassLoader, DocumentBuilderFactory.class);
            this.makeServiceVisible(serviceLocator, filteringClassLoader, DatatypeFactory.class);
        }
        return filteringClassLoader;
    }

    private void makeServiceVisible(ServiceLocator serviceLocator, FilteringClassLoader filteringClassLoader, Class<?> clazz) {
        filteringClassLoader.allowClass(serviceLocator.getFactory((Class)clazz).getImplementationClass());
        filteringClassLoader.allowResource("META-INF/services/" + clazz.getName());
    }

    private boolean needJaxpImpl() {
        return ClassLoader.getSystemResource("META-INF/services/javax.xml.parsers.SAXParserFactory") != null;
    }
}

