/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectUtil;
import org.gradle.util.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureUtil {
    public static <T> T configureByMap(Map<String, ?> map, T t) {
        DynamicObject dynamicObject = DynamicObjectUtil.asDynamicObject(t);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            Object obj = entry.getValue();
            if (dynamicObject.hasProperty(string)) {
                dynamicObject.setProperty(string, obj);
                continue;
            }
            try {
                dynamicObject.invokeMethod(string, obj);
            }
            catch (MissingMethodException missingMethodException) {
                dynamicObject.setProperty(string, obj);
            }
        }
        return t;
    }

    public static <T> T configureByMap(Map<String, ?> map, T t, Collection<String> collection) {
        Collection collection2 = CollectionUtils.subtract(collection, map.keySet());
        if (!collection2.isEmpty()) {
            throw new IncompleteInputException("Input configuration map does not contain following mandatory keys: " + collection2, collection2);
        }
        return ConfigureUtil.configureByMap(map, t);
    }

    public static <T> T configure(Closure closure, T t) {
        return ConfigureUtil.configure(closure, t, 1, true);
    }

    public static <T> T configure(Closure closure, T t, boolean bl) {
        return ConfigureUtil.configure(closure, t, 1, bl);
    }

    public static <T> T configure(Closure closure, T t, int n) {
        return ConfigureUtil.configure(closure, t, n, false);
    }

    private static <T> T configure(Closure closure, T t, int n, boolean bl) {
        if (closure == null) {
            return t;
        }
        if (bl && t instanceof Configurable) {
            ((Configurable)t).configure(closure);
        } else {
            Closure closure2 = (Closure)closure.clone();
            closure2.setResolveStrategy(n);
            closure2.setDelegate(t);
            if (closure2.getMaximumNumberOfParameters() == 0) {
                closure2.call();
            } else {
                closure2.call(t);
            }
        }
        return t;
    }

    public static class IncompleteInputException
    extends RuntimeException {
        private final Collection missingKeys;

        public IncompleteInputException(String string, Collection collection) {
            super(string);
            this.missingKeys = collection;
        }

        public Collection getMissingKeys() {
            return this.missingKeys;
        }
    }
}

