/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtils {
    public static <T> T findFirst(Iterable<T> iterable, Spec<? super T> spec) {
        for (T t : iterable) {
            if (!spec.isSatisfiedBy(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> Set<T> filter(Set<T> set, Spec<? super T> spec) {
        return CollectionUtils.filter(set, new LinkedHashSet(), spec);
    }

    public static <T> List<T> filter(List<T> list, Spec<? super T> spec) {
        return CollectionUtils.filter(list, new LinkedList(), spec);
    }

    public static <T, C extends Collection<T>> C filter(Iterable<T> iterable, C c, Spec<? super T> spec) {
        for (T t : iterable) {
            if (!spec.isSatisfiedBy(t)) continue;
            c.add(t);
        }
        return c;
    }

    public static <R, I> List<R> collect(List<? extends I> list, Transformer<R, I> transformer) {
        return CollectionUtils.collect(list, new ArrayList(list.size()), transformer);
    }

    public static <R, I> Set<R> collect(Set<? extends I> set, Transformer<R, I> transformer) {
        return CollectionUtils.collect(set, new HashSet(), transformer);
    }

    public static <R, I, C extends Collection<R>> C collect(Iterable<? extends I> iterable, C c, Transformer<R, I> transformer) {
        for (I i : iterable) {
            c.add(transformer.transform(i));
        }
        return c;
    }

    public static List<String> toStringList(Iterable<?> iterable) {
        ArrayList arrayList = Lists.newArrayList();
        for (Object obj : iterable) {
            arrayList.add(obj.toString());
        }
        return arrayList;
    }
}

