/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import org.gradle.util.TimeProvider;
import org.gradle.util.TrueTimeProvider;

public class Clock {
    private long start;
    private TimeProvider timeProvider;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_HOUR = 3600000L;

    public Clock() {
        this(new TrueTimeProvider());
    }

    public Clock(long l) {
        this(new TrueTimeProvider(), l);
    }

    protected Clock(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.reset();
    }

    protected Clock(TimeProvider timeProvider, long l) {
        this.timeProvider = timeProvider;
        this.start = l;
    }

    public String getTime() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = this.getTimeInMs();
        if (l > 3600000L) {
            stringBuffer.append(l / 3600000L).append(" hrs ");
        }
        if (l > 60000L) {
            stringBuffer.append(l % 3600000L / 60000L).append(" mins ");
        }
        stringBuffer.append((double)(l % 60000L) / 1000.0).append(" secs");
        return stringBuffer.toString();
    }

    public long getTimeInMs() {
        return this.timeProvider.getCurrentTime() - this.start;
    }

    public void reset() {
        this.start = this.timeProvider.getCurrentTime();
    }

    public long getStartTime() {
        return this.start;
    }
}

