/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.util.ClassLoaderBackedClasspathSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathUtil {
    public static void addUrl(URLClassLoader uRLClassLoader, Iterable<URL> iterable) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL uRL : iterable) {
                method.invoke((Object)uRLClassLoader, uRL);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error, could not add URL to classloader", throwable);
        }
    }

    public static List<URL> getClasspath(ClassLoader classLoader) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        new ClassLoaderBackedClasspathSource(classLoader).collectClasspath(arrayList);
        return arrayList;
    }

    public static File getClasspathForClass(Class<?> clazz) {
        URI uRI;
        try {
            uRI = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)uRISyntaxException);
        }
        if (!uRI.getScheme().equals("file")) {
            throw new GradleException(String.format("Cannot determine classpath for %s from codebase '%s'.", clazz.getName(), uRI));
        }
        return new File(uRI.getPath());
    }

    public static File getClasspathForResource(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return ClasspathUtil.getClasspathForResource(ClassLoader.getSystemResource(string), string);
        }
        return ClasspathUtil.getClasspathForResource(classLoader.getResource(string), string);
    }

    public static File getClasspathForResource(URL uRL, String string) {
        URI uRI;
        try {
            String string2;
            int n;
            uRI = uRL.toURI();
            String string3 = uRI.getPath();
            if (uRI.getScheme().equals("file")) {
                assert (string3.endsWith("/" + string));
                return new File(string3.substring(0, string3.length() - (string.length() + 1)));
            }
            if (uRI.getScheme().equals("jar") && (n = (string2 = uRI.getRawSchemeSpecificPart()).indexOf("!")) > 0) {
                assert (string2.substring(n + 1).equals("/" + string));
                URI uRI2 = new URI(string2.substring(0, n));
                if (uRI2.getScheme().equals("file")) {
                    return new File(uRI2.getPath());
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw UncheckedException.throwAsUncheckedException((Throwable)uRISyntaxException);
        }
        throw new GradleException(String.format("Cannot determine classpath for resource '%s' from location '%s'.", string, uRI));
    }
}

