/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import org.gradle.util.ClasspathSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderBackedClasspathSource
implements ClasspathSource {
    private final ClassLoader classLoader;

    public ClassLoaderBackedClasspathSource(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void collectClasspath(Collection<? super URL> collection) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader() == null ? null : ClassLoader.getSystemClassLoader().getParent();
        for (ClassLoader classLoader2 = this.classLoader; classLoader2 != null && classLoader2 != classLoader; classLoader2 = classLoader2.getParent()) {
            if (classLoader2 instanceof ClasspathSource) {
                ClasspathSource classpathSource = (ClasspathSource)((Object)classLoader2);
                classpathSource.collectClasspath(collection);
                break;
            }
            if (!(classLoader2 instanceof URLClassLoader)) continue;
            collection.addAll(Arrays.asList(((URLClassLoader)classLoader2).getURLs()));
        }
    }
}

