/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AvailablePortFinder {
    private static final int MIN_PRIVATE_PORT = 49152;
    private static final int MAX_PRIVATE_PORT = 65535;
    private final Lock lock = new ReentrantLock();
    private final int startPort;
    private int current = this.startPort = new Random().nextInt(16383) + 49152;

    public static AvailablePortFinder createPrivate() {
        return new AvailablePortFinder();
    }

    public int getNextAvailable() {
        this.lock.lock();
        try {
            while (true) {
                this.current = this.current >= 65535 ? 49152 : ++this.current;
                if (this.current == this.startPort) {
                    throw new NoSuchElementException("Could not find an available port within port range.");
                }
                int n = this.current;
                if (!this.available(n)) continue;
                int n2 = n;
                return n2;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean available(int n) {
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            try {
                serverSocket.setReuseAddress(true);
            }
            finally {
                serverSocket.close();
            }
            DatagramSocket datagramSocket = new DatagramSocket(n);
            try {
                datagramSocket.setReuseAddress(true);
            }
            finally {
                datagramSocket.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

