/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.invocation.DefaultGradle;
import org.gradle.testfixtures.internal.GlobalTestServices;
import org.gradle.testfixtures.internal.TestTopLevelBuildServiceRegistry;
import org.gradle.util.GFileUtils;

public class ProjectBuilderImpl {
    private static final GlobalTestServices GLOBAL_SERVICES = new GlobalTestServices();
    private static final AsmBackedClassGenerator CLASS_GENERATOR = new AsmBackedClassGenerator();

    public Project createChildProject(String string, Project project, File file) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        DefaultProject defaultProject = CLASS_GENERATOR.newInstance(DefaultProject.class, string, projectInternal, file != null ? file.getAbsoluteFile() : new File(projectInternal.getProjectDir(), string), new StringScriptSource("test build file", null), projectInternal.getGradle(), projectInternal.getGradle().getServices());
        projectInternal.addChildProject(defaultProject);
        projectInternal.getProjectRegistry().addProject(defaultProject);
        return defaultProject;
    }

    public Project createProject(String string, File file) {
        File file2 = this.prepareProjectDir(file);
        File file3 = new File(file2, "gradleHome");
        StartParameter startParameter = new StartParameter();
        startParameter.setGradleUserHomeDir(new File(file2, "userHome"));
        TestTopLevelBuildServiceRegistry testTopLevelBuildServiceRegistry = new TestTopLevelBuildServiceRegistry((ServiceRegistry)GLOBAL_SERVICES, startParameter, file3);
        DefaultGradle defaultGradle = new DefaultGradle(null, startParameter, testTopLevelBuildServiceRegistry);
        DefaultProjectDescriptor defaultProjectDescriptor = new DefaultProjectDescriptor(null, string, file2, new DefaultProjectDescriptorRegistry());
        ProjectInternal projectInternal = ((IProjectFactory)testTopLevelBuildServiceRegistry.get(IProjectFactory.class)).createProject(defaultProjectDescriptor, null, defaultGradle);
        defaultGradle.setRootProject(projectInternal);
        defaultGradle.setDefaultProject(projectInternal);
        defaultGradle.getScriptClassLoader().addParent(this.getClass().getClassLoader());
        return projectInternal;
    }

    public File prepareProjectDir(File file) {
        if (file == null) {
            TmpDirTemporaryFileProvider tmpDirTemporaryFileProvider = new TmpDirTemporaryFileProvider();
            file = tmpDirTemporaryFileProvider.createTemporaryDirectory("gradle", "projectDir", new String[0]);
            file.deleteOnExit();
        } else {
            file = GFileUtils.canonicalise(file);
        }
        return file;
    }
}

