/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.api.internal.changedetection.InMemoryIndexedCache;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.SimpleStateCache;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCacheFactory
implements CacheFactory {
    @Override
    public PersistentCache openStore(File file, String string, FileLockManager.LockMode lockMode, Action<? super PersistentCache> action) throws CacheOpenException {
        return this.open(file, string, CacheUsage.ON, null, Collections.emptyMap(), lockMode, action);
    }

    @Override
    public PersistentCache open(File file, String string, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Action<? super PersistentCache> action) {
        file.mkdirs();
        InMemoryCache inMemoryCache = new InMemoryCache(file);
        if (action != null) {
            action.execute(inMemoryCache);
        }
        return inMemoryCache;
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> openIndexedCache(File file, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Serializer<V> serializer) {
        return new InMemoryIndexedCache();
    }

    @Override
    public <E> PersistentStateCache<E> openStateCache(File file, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Serializer<E> serializer) {
        file.mkdirs();
        return new SimpleStateCache(new File(file, "state.bin"), new NoOpFileLock(), new DefaultSerializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InMemoryCache
    implements PersistentCache {
        private final File cacheDir;

        public InMemoryCache(File file) {
            this.cacheDir = file;
        }

        @Override
        public File getBaseDir() {
            return this.cacheDir;
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(File file, Class<K> clazz, Class<V> clazz2) {
            return new InMemoryIndexedCache();
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(File file, Class<K> clazz, Serializer<V> serializer) {
            return new InMemoryIndexedCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T useCache(String string, Factory<? extends T> factory) {
            InMemoryCache inMemoryCache = this;
            synchronized (inMemoryCache) {
                return (T)factory.create();
            }
        }

        @Override
        public void useCache(String string, Runnable runnable) {
            runnable.run();
        }

        @Override
        public <T> T longRunningOperation(String string, Factory<? extends T> factory) {
            return (T)factory.create();
        }

        @Override
        public void longRunningOperation(String string, Runnable runnable) {
            runnable.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOpFileLock
    extends AbstractFileAccess {
        private NoOpFileLock() {
        }

        @Override
        public <T> T readFromFile(Factory<? extends T> factory) throws LockTimeoutException {
            return (T)factory.create();
        }

        @Override
        public void writeToFile(Runnable runnable) throws LockTimeoutException {
            runnable.run();
        }

        public void close() {
        }
    }
}

