/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.util.ArrayList;
import java.util.List;
import org.gradle.reporting.DomReportRenderer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabsRenderer<T>
extends DomReportRenderer<T> {
    private final List<TabDefinition> tabs = new ArrayList<TabDefinition>();

    public void add(String string, DomReportRenderer<T> domReportRenderer) {
        this.tabs.add(new TabDefinition(string, domReportRenderer));
    }

    public void clear() {
        this.tabs.clear();
    }

    @Override
    public void render(T t, Element element) {
        Element element2 = this.appendWithId(element, "div", "tabs");
        Element element3 = this.append(element2, "ul");
        element3.setAttribute("class", "tabLinks");
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabDefinition tabDefinition = this.tabs.get(i);
            Element element4 = this.append(element3, "li");
            Element element5 = this.appendWithText(element4, "a", tabDefinition.title);
            String string = String.format("tab%s", i);
            element5.setAttribute("href", "#" + string);
            Element element6 = this.appendWithId(element2, "div", string);
            element6.setAttribute("class", "tab");
            this.appendWithText(element6, "h2", tabDefinition.title);
            tabDefinition.renderer.render(t, element6);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TabDefinition {
        final String title;
        final DomReportRenderer<T> renderer;

        private TabDefinition(String string, DomReportRenderer<T> domReportRenderer) {
            this.title = string;
            this.renderer = domReportRenderer;
        }
    }
}

