/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.io.File;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.reporting.DomReportRenderer;
import org.gradle.reporting.TextReportRenderer;
import org.gradle.util.GFileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlReportRenderer {
    private DocumentBuilder documentBuilder;
    private Transformer transformer;
    private final Set<URL> resources = new HashSet<URL>();

    public void requireResource(URL uRL) {
        this.resources.add(uRL);
    }

    public <T> TextReportRenderer<T> renderer(final DomReportRenderer<T> domReportRenderer) {
        return this.renderer(new TextReportRenderer<T>(){

            @Override
            protected void writeTo(T t, Writer writer) throws Exception {
                if (HtmlReportRenderer.this.documentBuilder == null) {
                    HtmlReportRenderer.this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                }
                Document document = HtmlReportRenderer.this.documentBuilder.newDocument();
                Element element = document.createElement("html");
                document.appendChild(element);
                domReportRenderer.render(t, element);
                if (HtmlReportRenderer.this.transformer == null) {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    HtmlReportRenderer.this.transformer = transformerFactory.newTransformer();
                    HtmlReportRenderer.this.transformer.setOutputProperty("indent", "yes");
                    HtmlReportRenderer.this.transformer.setOutputProperty("method", "html");
                    HtmlReportRenderer.this.transformer.setOutputProperty("media-type", "text/html");
                }
                writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
                writer.write(SystemProperties.getLineSeparator());
                HtmlReportRenderer.this.transformer.transform(new DOMSource(document), new StreamResult(writer));
            }
        });
    }

    public <T> TextReportRenderer<T> renderer(final TextReportRenderer<T> textReportRenderer) {
        return new TextReportRenderer<T>(){

            @Override
            protected void writeTo(T t, Writer writer) throws Exception {
                textReportRenderer.writeTo(t, writer);
            }

            @Override
            public void writeTo(T t, File file) {
                super.writeTo(t, file);
                for (URL uRL : HtmlReportRenderer.this.resources) {
                    String string = StringUtils.substringAfterLast((String)uRL.getPath(), (String)"/");
                    File file2 = new File(file.getParentFile(), string);
                    if (file2.exists()) continue;
                    GFileUtils.copyURLToFile(uRL, file2);
                }
            }
        };
    }
}

