/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.math.BigDecimal;

public class DurationFormatter {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;

    public String format(long l) {
        if (l == 0L) {
            return "0s";
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 86400000L;
        l %= 86400000L;
        if (l2 > 0L) {
            stringBuilder.append(l2);
            stringBuilder.append("d");
        }
        long l3 = l / 3600000L;
        l %= 3600000L;
        if (l3 > 0L || stringBuilder.length() > 0) {
            stringBuilder.append(l3);
            stringBuilder.append("h");
        }
        long l4 = l / 60000L;
        l %= 60000L;
        if (l4 > 0L || stringBuilder.length() > 0) {
            stringBuilder.append(l4);
            stringBuilder.append("m");
        }
        int n = stringBuilder.length() > 0 ? 2 : 3;
        stringBuilder.append(BigDecimal.valueOf(l).divide(BigDecimal.valueOf(1000L)).setScale(n, 4));
        stringBuilder.append("s");
        return stringBuilder.toString();
    }
}

