/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.BuildAdapter;
import org.gradle.api.invocation.Gradle;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.ProfileListener;
import org.gradle.profile.ProfileReportRenderer;

public class ReportGeneratingProfileListener
extends BuildAdapter
implements ProfileListener {
    private static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private File buildDir;

    public void projectsEvaluated(Gradle gradle) {
        this.buildDir = gradle.getRootProject().getBuildDir();
    }

    public void buildFinished(BuildProfile buildProfile) {
        ProfileReportRenderer profileReportRenderer = new ProfileReportRenderer();
        File file = new File(this.buildDir, "reports/profile/profile-" + FILE_DATE_FORMAT.format(new Date(buildProfile.getBuildStarted())) + ".html");
        profileReportRenderer.writeTo(buildProfile, file);
    }
}

