/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.HashMap;
import org.gradle.api.Project;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectProfile {
    private final Project project;
    private ProjectState state;
    private HashMap<Task, TaskExecution> tasks = new HashMap();
    private final ContinuousOperation evaluation = new ContinuousOperation(){

        public String getPath() {
            return ProjectProfile.this.project.getPath();
        }
    };

    public ProjectProfile(Project project) {
        this.project = project;
    }

    public TaskExecution getTaskProfile(Task task) {
        TaskExecution taskExecution = this.tasks.get(task);
        if (taskExecution == null) {
            taskExecution = new TaskExecution(task);
            this.tasks.put(task, taskExecution);
        }
        return taskExecution;
    }

    public CompositeOperation<TaskExecution> getTasks() {
        return new CompositeOperation<TaskExecution>(this.tasks.values());
    }

    public String getPath() {
        return this.project.getPath();
    }

    public ContinuousOperation getEvaluation() {
        return this.evaluation;
    }

    public ProjectState getState() {
        return this.state;
    }

    public void setState(ProjectState projectState) {
        this.state = projectState;
    }
}

