/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.HTMLProfileReport;
import org.gradle.reporting.DomReportRenderer;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TextDomReportRenderer;
import org.w3c.dom.Element;

public class ProfileReportRenderer {
    public void writeTo(BuildProfile buildProfile, File file) {
        HtmlReportRenderer htmlReportRenderer = new HtmlReportRenderer();
        htmlReportRenderer.requireResource(this.getClass().getResource("/org/gradle/reporting/base-style.css"));
        htmlReportRenderer.requireResource(this.getClass().getResource("/org/gradle/reporting/report.js"));
        htmlReportRenderer.requireResource(this.getClass().getResource("/org/gradle/reporting/css3-pie-1.0beta3.htc"));
        htmlReportRenderer.requireResource(this.getClass().getResource("style.css"));
        htmlReportRenderer.renderer(new ProfilePageRenderer()).writeTo(buildProfile, file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProfilePageRenderer
    extends TabbedPageRenderer<BuildProfile> {
        static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd - HH:mm:ss");

        private ProfilePageRenderer() {
        }

        @Override
        protected String getTitle() {
            return "Profile report";
        }

        @Override
        protected DomReportRenderer<BuildProfile> getHeaderRenderer() {
            return new DomReportRenderer<BuildProfile>(){

                @Override
                public void render(BuildProfile buildProfile, Element element) {
                    Element element2 = this.appendWithId(element, "div", "header");
                    this.appendWithText(element2, "p", String.format("Profiled with tasks: %s", buildProfile.getTaskDescription()));
                    this.appendWithText(element2, "p", String.format("Run on: %s", DATE_FORMAT.format(buildProfile.getBuildStarted())));
                }
            };
        }

        @Override
        protected DomReportRenderer<BuildProfile> getContentRenderer() {
            return new TextDomReportRenderer<BuildProfile>(new HTMLProfileReport());
        }
    }
}

