/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.DependencyResolveProfile;
import org.gradle.profile.ProfileListener;
import org.gradle.profile.ProjectProfile;
import org.gradle.profile.TaskExecution;
import org.gradle.util.TimeProvider;

public class ProfileEventAdapter
implements BuildListener,
ProjectEvaluationListener,
TaskExecutionListener,
DependencyResolutionListener {
    private final BuildRequestMetaData buildMetaData;
    private final TimeProvider timeProvider;
    private final ProfileListener listener;
    private BuildProfile buildProfile;

    public ProfileEventAdapter(BuildRequestMetaData buildRequestMetaData, TimeProvider timeProvider, ProfileListener profileListener) {
        this.buildMetaData = buildRequestMetaData;
        this.timeProvider = timeProvider;
        this.listener = profileListener;
    }

    public void buildStarted(Gradle gradle) {
        this.buildProfile = new BuildProfile(gradle);
        this.buildProfile.setBuildStarted(this.timeProvider.getCurrentTime());
        this.buildProfile.setProfilingStarted(this.buildMetaData.getBuildTimeClock().getStartTime());
    }

    public void settingsEvaluated(Settings settings) {
        this.buildProfile.setSettingsEvaluated(this.timeProvider.getCurrentTime());
    }

    public void projectsLoaded(Gradle gradle) {
        this.buildProfile.setProjectsLoaded(this.timeProvider.getCurrentTime());
    }

    public void projectsEvaluated(Gradle gradle) {
        this.buildProfile.setProjectsEvaluated(this.timeProvider.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildResult buildResult) {
        this.buildProfile.setBuildFinished(this.timeProvider.getCurrentTime());
        this.buildProfile.setSuccessful(buildResult.getFailure() == null);
        try {
            this.listener.buildFinished(this.buildProfile);
        }
        finally {
            this.buildProfile = null;
        }
    }

    public void beforeEvaluate(Project project) {
        this.buildProfile.getProjectProfile(project).getEvaluation().setStart(System.currentTimeMillis());
    }

    public void afterEvaluate(Project project, ProjectState projectState) {
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project);
        projectProfile.getEvaluation().setFinish(this.timeProvider.getCurrentTime());
        projectProfile.setState(projectState);
    }

    public void beforeExecute(Task task) {
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project);
        projectProfile.getTaskProfile(task).setStart(this.timeProvider.getCurrentTime());
    }

    public void afterExecute(Task task, TaskState taskState) {
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project);
        TaskExecution taskExecution = projectProfile.getTaskProfile(task);
        taskExecution.setFinish(this.timeProvider.getCurrentTime());
        taskExecution.setState(taskState);
    }

    public void beforeResolve(ResolvableDependencies resolvableDependencies) {
        DependencyResolveProfile dependencyResolveProfile = this.buildProfile.getDependencySetProfile(resolvableDependencies);
        dependencyResolveProfile.setStart(this.timeProvider.getCurrentTime());
    }

    public void afterResolve(ResolvableDependencies resolvableDependencies) {
        DependencyResolveProfile dependencyResolveProfile = this.buildProfile.getDependencySetProfile(resolvableDependencies);
        dependencyResolveProfile.setFinish(this.timeProvider.getCurrentTime());
    }
}

