/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.invocation.Gradle;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.DependencyResolveProfile;
import org.gradle.profile.Operation;
import org.gradle.profile.ProjectProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildProfile {
    private final Gradle gradle;
    private final Map<Project, ProjectProfile> projects = new LinkedHashMap<Project, ProjectProfile>();
    private final Map<String, DependencyResolveProfile> dependencySets = new LinkedHashMap<String, DependencyResolveProfile>();
    private long profilingStarted;
    private long buildStarted;
    private long settingsEvaluated;
    private long projectsLoaded;
    private long projectsEvaluated;
    private long buildFinished;
    private boolean successful;

    public BuildProfile(Gradle gradle) {
        this.gradle = gradle;
    }

    public Gradle getGradle() {
        return this.gradle;
    }

    public long getBuildStarted() {
        return this.buildStarted;
    }

    public String getTaskDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.gradle.getStartParameter().getExcludedTaskNames()) {
            stringBuilder.append("-x");
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        for (String string : this.gradle.getStartParameter().getTaskNames()) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public ProjectProfile getProjectProfile(Project project) {
        ProjectProfile projectProfile = this.projects.get(project);
        if (projectProfile == null) {
            projectProfile = new ProjectProfile(project);
            this.projects.put(project, projectProfile);
        }
        return projectProfile;
    }

    public List<ProjectProfile> getProjects() {
        return new ArrayList<ProjectProfile>(this.projects.values());
    }

    public CompositeOperation<Operation> getProjectConfiguration() {
        ArrayList<ContinuousOperation> arrayList = new ArrayList<ContinuousOperation>();
        for (ProjectProfile projectProfile : this.projects.values()) {
            arrayList.add(projectProfile.getEvaluation());
        }
        return new CompositeOperation<Operation>(arrayList);
    }

    public DependencyResolveProfile getDependencySetProfile(ResolvableDependencies resolvableDependencies) {
        DependencyResolveProfile dependencyResolveProfile = this.dependencySets.get(resolvableDependencies.getPath());
        if (dependencyResolveProfile == null) {
            dependencyResolveProfile = new DependencyResolveProfile(resolvableDependencies);
            this.dependencySets.put(resolvableDependencies.getPath(), dependencyResolveProfile);
        }
        return dependencyResolveProfile;
    }

    public CompositeOperation<DependencyResolveProfile> getDependencySets() {
        return new CompositeOperation<DependencyResolveProfile>(this.dependencySets.values());
    }

    public void setProfilingStarted(long l) {
        this.profilingStarted = l;
    }

    public void setBuildStarted(long l) {
        this.buildStarted = l;
    }

    public void setSettingsEvaluated(long l) {
        this.settingsEvaluated = l;
    }

    public void setProjectsLoaded(long l) {
        this.projectsLoaded = l;
    }

    public void setProjectsEvaluated(long l) {
        this.projectsEvaluated = l;
    }

    public void setBuildFinished(long l) {
        this.buildFinished = l;
    }

    public long getElapsedStartup() {
        return this.buildStarted - this.profilingStarted;
    }

    public long getElapsedTotal() {
        return this.buildFinished - this.profilingStarted;
    }

    public long getElapsedSettings() {
        return this.settingsEvaluated - this.buildStarted;
    }

    public long getElapsedProjectsLoading() {
        return this.projectsLoaded - this.settingsEvaluated;
    }

    public long getElapsedProjectsEvaluated() {
        return this.projectsEvaluated - this.projectsLoaded;
    }

    public long getElapsedAfterProjectsEvaluated() {
        return this.buildFinished - this.projectsEvaluated;
    }

    public long getElapsedTotalExecutionTime() {
        long l = 0L;
        for (ProjectProfile projectProfile : this.projects.values()) {
            l += projectProfile.getTasks().getElapsedTime();
        }
        return l;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean bl) {
        this.successful = bl;
    }
}

