/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.shutdown;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.UncheckedIOException;

public class ShutdownHookActionRegister {
    private static final ShutdownHookActionRegister INSTANCE = new ShutdownHookActionRegister();
    private final List<Runnable> shutdownHookActions = new CopyOnWriteArrayList<Runnable>();

    private ShutdownHookActionRegister() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new GradleShutdownHook(), "gradle-shutdown-hook"));
    }

    public static void addAction(Runnable runnable) {
        ShutdownHookActionRegister.INSTANCE.shutdownHookActions.add(runnable);
    }

    public static void removeAction(Runnable runnable) {
        ShutdownHookActionRegister.INSTANCE.shutdownHookActions.remove(runnable);
    }

    public static void closeOnExit(final Closeable closeable) {
        ShutdownHookActionRegister.addAction(new Runnable(){

            public void run() {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
        });
    }

    private class GradleShutdownHook
    implements Runnable {
        private GradleShutdownHook() {
        }

        public void run() {
            for (Runnable runnable : ShutdownHookActionRegister.this.shutdownHookActions) {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    System.err.println("failed to execute a shutdown action.");
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }
}

