/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.File;
import java.util.Arrays;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.process.internal.child.BootstrapSecurityManager;
import org.gradle.process.internal.launcher.BootstrapClassLoaderWorker;
import org.gradle.process.internal.launcher.GradleWorkerMain;
import org.gradle.util.ClassPath;
import org.gradle.util.DefaultClassPath;
import org.gradle.util.GFileUtils;

public class WorkerProcessClassPathProvider
implements ClassPathProvider {
    private final CacheRepository cacheRepository;
    private final ModuleRegistry moduleRegistry;
    private final Object lock = new Object();
    private ClassPath workerClassPath;

    public WorkerProcessClassPathProvider(CacheRepository cacheRepository, ModuleRegistry moduleRegistry) {
        this.cacheRepository = cacheRepository;
        this.moduleRegistry = moduleRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath findClassPath(String string) {
        if (string.equals("WORKER_PROCESS")) {
            ClassPath classPath = new DefaultClassPath(new File[0]);
            classPath = classPath.plus(this.moduleRegistry.getModule("gradle-base-services").getImplementationClasspath());
            classPath = classPath.plus(this.moduleRegistry.getModule("gradle-core").getImplementationClasspath());
            classPath = classPath.plus(this.moduleRegistry.getModule("gradle-cli").getImplementationClasspath());
            classPath = classPath.plus(this.moduleRegistry.getModule("gradle-native").getImplementationClasspath());
            classPath = classPath.plus(this.moduleRegistry.getExternalModule("slf4j-api").getClasspath());
            classPath = classPath.plus(this.moduleRegistry.getExternalModule("logback-classic").getClasspath());
            classPath = classPath.plus(this.moduleRegistry.getExternalModule("logback-core").getClasspath());
            classPath = classPath.plus(this.moduleRegistry.getExternalModule("jul-to-slf4j").getClasspath());
            return classPath;
        }
        if (string.equals("WORKER_MAIN")) {
            Object object = this.lock;
            synchronized (object) {
                if (this.workerClassPath == null) {
                    PersistentCache persistentCache = (PersistentCache)this.cacheRepository.cache("workerMain").withInitializer(new CacheInitializer()).open();
                    this.workerClassPath = new DefaultClassPath(WorkerProcessClassPathProvider.classesDir(persistentCache));
                }
                return this.workerClassPath;
            }
        }
        return null;
    }

    private static File classesDir(PersistentCache persistentCache) {
        return new File(persistentCache.getBaseDir(), "classes");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheInitializer
    implements Action<PersistentCache> {
        private CacheInitializer() {
        }

        @Override
        public void execute(PersistentCache persistentCache) {
            File file = WorkerProcessClassPathProvider.classesDir(persistentCache);
            for (Class clazz : Arrays.asList(GradleWorkerMain.class, BootstrapClassLoaderWorker.class, BootstrapSecurityManager.class)) {
                String string = clazz.getName().replace('.', '/') + ".class";
                GFileUtils.copyURLToFile(WorkerProcessClassPathProvider.class.getClassLoader().getResource(string), new File(file, string));
            }
        }
    }
}

