/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.process.internal.child.WorkerContext;
import org.gradle.util.DefaultClassLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolatedApplicationClassLoaderWorker
implements Callable<Void>,
Serializable {
    private final Action<WorkerContext> worker;
    private final Collection<URI> applicationClassPath;

    public IsolatedApplicationClassLoaderWorker(Collection<URI> collection, Action<WorkerContext> action) {
        this.applicationClassPath = collection;
        this.worker = action;
    }

    @Override
    public Void call() throws Exception {
        final ClassLoader classLoader = this.createApplicationClassLoader();
        WorkerContext workerContext = new WorkerContext(){

            public ClassLoader getApplicationClassLoader() {
                return classLoader;
            }
        };
        this.worker.execute(workerContext);
        return null;
    }

    private ClassLoader createApplicationClassLoader() {
        return new DefaultClassLoaderFactory().createIsolatedClassLoader(this.applicationClassPath);
    }
}

