/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.UncheckedException;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.process.internal.child.WorkerContext;
import org.gradle.util.ClassLoaderObjectInputStream;
import org.gradle.util.FilteringClassLoader;
import org.gradle.util.GUtil;
import org.gradle.util.MultiParentClassLoader;
import org.gradle.util.MutableURLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationClassLoaderWorker
implements Action<WorkerContext>,
Serializable {
    private final LogLevel logLevel;
    private final Collection<String> sharedPackages;
    private final Collection<URL> implementationClassPath;
    private final byte[] serializedWorkerAction;

    protected ImplementationClassLoaderWorker(LogLevel logLevel, Collection<String> collection, Collection<URL> collection2, Action<WorkerContext> action) {
        this.logLevel = logLevel;
        this.sharedPackages = collection;
        this.implementationClassPath = collection2;
        this.serializedWorkerAction = GUtil.serialize(action);
    }

    @Override
    public void execute(WorkerContext workerContext) {
        Action action;
        LoggingManagerInternal loggingManagerInternal = this.createLoggingManager();
        loggingManagerInternal.setLevel(this.logLevel).start();
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(this.getClass().getClassLoader());
        filteringClassLoader.allowPackage("org.slf4j");
        filteringClassLoader.allowClass(Action.class);
        filteringClassLoader.allowClass(WorkerContext.class);
        ClassLoader classLoader = workerContext.getApplicationClassLoader();
        FilteringClassLoader filteringClassLoader2 = new FilteringClassLoader(classLoader);
        MutableURLClassLoader mutableURLClassLoader = this.createImplementationClassLoader(filteringClassLoader, filteringClassLoader2);
        for (String object : this.sharedPackages) {
            filteringClassLoader2.allowPackage(object);
        }
        mutableURLClassLoader.addURLs(this.implementationClassPath);
        try {
            ClassLoaderObjectInputStream exception = new ClassLoaderObjectInputStream(new ByteArrayInputStream(this.serializedWorkerAction), mutableURLClassLoader);
            action = (Action)exception.readObject();
        }
        catch (Exception exception) {
            throw UncheckedException.throwAsUncheckedException((Throwable)exception);
        }
        action.execute(workerContext);
    }

    LoggingManagerInternal createLoggingManager() {
        return (LoggingManagerInternal)LoggingServiceRegistry.newChildProcessLogging().newInstance(LoggingManagerInternal.class);
    }

    MutableURLClassLoader createImplementationClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        return new MutableURLClassLoader((ClassLoader)new MultiParentClassLoader(classLoader2, classLoader), new URL[0]);
    }
}

