/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.messaging.remote.Address;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ActionExecutionWorker;
import org.gradle.process.internal.child.BootstrapSecurityManager;
import org.gradle.process.internal.child.ImplementationClassLoaderWorker;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.process.internal.launcher.BootstrapClassLoaderWorker;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInSystemClassLoaderWorkerFactory
implements WorkerFactory {
    private final Object workerId;
    private final String displayName;
    private final WorkerProcessBuilder processBuilder;
    private final List<URL> implementationClassPath;
    private final Address serverAddress;
    private final ClassPathRegistry classPathRegistry;

    public ApplicationClassesInSystemClassLoaderWorkerFactory(Object object, String string, WorkerProcessBuilder workerProcessBuilder, List<URL> list, Address address, ClassPathRegistry classPathRegistry) {
        this.workerId = object;
        this.displayName = string;
        this.processBuilder = workerProcessBuilder;
        this.implementationClassPath = list;
        this.serverAddress = address;
        this.classPathRegistry = classPathRegistry;
    }

    @Override
    public void prepareJavaCommand(JavaExecSpec javaExecSpec) {
        javaExecSpec.classpath(this.classPathRegistry.getClassPath("WORKER_MAIN").getAsFiles());
        Object object = javaExecSpec.getSystemProperties().get("java.security.manager");
        if (object != null) {
            javaExecSpec.systemProperty("org.gradle.security.manager", object);
        }
        javaExecSpec.systemProperty("java.security.manager", BootstrapSecurityManager.class.getName());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.processBuilder.getApplicationClasspath().size());
            for (File object22 : this.processBuilder.getApplicationClasspath()) {
                dataOutputStream.writeUTF(object22.getAbsolutePath());
            }
            dataOutputStream.close();
            final InputStream inputStream = javaExecSpec.getStandardInput();
            InputStream inputStream2 = (InputStream)ByteStreams.join((InputSupplier[])new InputSupplier[]{ByteStreams.newInputStreamSupplier((byte[])byteArrayOutputStream.toByteArray()), new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return inputStream;
                }
            }}).getInput();
            javaExecSpec.setStandardInput(inputStream2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public Callable<?> create() {
        ActionExecutionWorker actionExecutionWorker = new ActionExecutionWorker(this.processBuilder.getWorker(), this.workerId, this.displayName, this.serverAddress);
        ImplementationClassLoaderWorker implementationClassLoaderWorker = new ImplementationClassLoaderWorker(this.processBuilder.getLogLevel(), this.processBuilder.getSharedPackages(), this.implementationClassPath, actionExecutionWorker);
        byte[] byArray = GUtil.serialize(implementationClassLoaderWorker);
        return new BootstrapClassLoaderWorker(this.classPathRegistry.getClassPath("WORKER_PROCESS").getAsURLs(), byArray);
    }
}

