/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.messaging.remote.Address;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ActionExecutionWorker;
import org.gradle.process.internal.child.ImplementationClassLoaderWorker;
import org.gradle.process.internal.child.IsolatedApplicationClassLoaderWorker;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInIsolatedClassLoaderWorkerFactory
implements WorkerFactory {
    private final Object workerId;
    private final String displayName;
    private final WorkerProcessBuilder processBuilder;
    private final Collection<URL> implementationClassPath;
    private final Address serverAddress;
    private final ClassPathRegistry classPathRegistry;

    public ApplicationClassesInIsolatedClassLoaderWorkerFactory(Object object, String string, WorkerProcessBuilder workerProcessBuilder, Collection<URL> collection, Address address, ClassPathRegistry classPathRegistry) {
        this.workerId = object;
        this.displayName = string;
        this.processBuilder = workerProcessBuilder;
        this.implementationClassPath = collection;
        this.serverAddress = address;
        this.classPathRegistry = classPathRegistry;
    }

    @Override
    public void prepareJavaCommand(JavaExecSpec javaExecSpec) {
        javaExecSpec.classpath(this.classPathRegistry.getClassPath("WORKER_PROCESS").getAsFiles());
    }

    @Override
    public Callable<?> create() {
        List<URI> list = GFileUtils.toURIs(this.processBuilder.getApplicationClasspath());
        ActionExecutionWorker actionExecutionWorker = new ActionExecutionWorker(this.processBuilder.getWorker(), this.workerId, this.displayName, this.serverAddress);
        ImplementationClassLoaderWorker implementationClassLoaderWorker = new ImplementationClassLoaderWorker(this.processBuilder.getLogLevel(), this.processBuilder.getSharedPackages(), this.implementationClassPath, actionExecutionWorker);
        return new IsolatedApplicationClassLoaderWorker(list, implementationClassLoaderWorker);
    }
}

