/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.MessagingClient;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.MessagingServices;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.process.internal.child.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionExecutionWorker
implements Action<WorkerContext>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionExecutionWorker.class);
    private final Action<WorkerProcessContext> action;
    private final Object workerId;
    private final String displayName;
    private final Address serverAddress;

    public ActionExecutionWorker(Action<WorkerProcessContext> action, Object object, String string, Address address) {
        this.action = action;
        this.workerId = object;
        this.displayName = string;
        this.serverAddress = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final WorkerContext workerContext) {
        MessagingServices messagingServices = this.createClient();
        MessagingClient messagingClient = (MessagingClient)messagingServices.get(MessagingClient.class);
        final ObjectConnection objectConnection = messagingClient.getConnection(this.serverAddress);
        try {
            LOGGER.debug("Starting {}.", (Object)this.displayName);
            WorkerProcessContext workerProcessContext = new WorkerProcessContext(){

                public ObjectConnection getServerConnection() {
                    return objectConnection;
                }

                public ClassLoader getApplicationClassLoader() {
                    return workerContext.getApplicationClassLoader();
                }

                public Object getWorkerId() {
                    return ActionExecutionWorker.this.workerId;
                }

                public String getDisplayName() {
                    return ActionExecutionWorker.this.displayName;
                }
            };
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute(workerProcessContext);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            LOGGER.debug("Completed {}.", (Object)this.displayName);
        }
        finally {
            LOGGER.debug("Stopping client connection.");
            messagingServices.stop();
        }
    }

    MessagingServices createClient() {
        return new MessagingServices(this.getClass().getClassLoader());
    }
}

