/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.internal.ArgumentsSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmOptions {
    private static final Pattern SYS_PROP_PATTERN = Pattern.compile("-D(.+?)=(.*)");
    private static final Pattern DEFAULT_ENCODING_PATTERN = Pattern.compile("-Dfile\\Q.\\Eencoding=(.*)");
    private static final Pattern NO_ARG_SYS_PROP_PATTERN = Pattern.compile("-D([^=]+)");
    private static final Pattern MIN_HEAP_PATTERN = Pattern.compile("-Xms(.+)");
    private static final Pattern MAX_HEAP_PATTERN = Pattern.compile("-Xmx(.+)");
    private static final Pattern BOOTSTRAP_PATTERN = Pattern.compile("-Xbootclasspath:(.+)");
    private final List<Object> extraJvmArgs = new ArrayList<Object>();
    private final Map<String, Object> systemProperties = new TreeMap<String, Object>();
    private DefaultConfigurableFileCollection bootstrapClasspath;
    private String minHeapSize;
    private String maxHeapSize;
    private boolean assertionsEnabled;
    private boolean debug;
    private String defaultCharacterEncoding;

    public JvmOptions(FileResolver fileResolver) {
        this.bootstrapClasspath = new DefaultConfigurableFileCollection(fileResolver, null, new Object[0]);
    }

    public List<String> getAllJvmArgs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<String, Object> entry : this.getSystemProperties().entrySet()) {
            if (entry.getValue() != null) {
                linkedList.add(String.format("-D%s=%s", entry.getKey(), entry.getValue().toString()));
                continue;
            }
            linkedList.add(String.format("-D%s", entry.getKey()));
        }
        linkedList.addAll(this.getAllImmutableJvmArgs());
        return linkedList;
    }

    public List<String> getAllImmutableJvmArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getJvmArgs());
        arrayList.addAll(this.getManagedJvmArgs());
        return arrayList;
    }

    public List<String> getManagedJvmArgs() {
        FileCollection fileCollection;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.minHeapSize != null) {
            arrayList.add(String.format("-Xms%s", this.minHeapSize));
        }
        if (this.maxHeapSize != null) {
            arrayList.add(String.format("-Xmx%s", this.maxHeapSize));
        }
        if (!(fileCollection = this.getBootstrapClasspath()).isEmpty()) {
            arrayList.add(String.format("-Xbootclasspath:%s", fileCollection.getAsPath()));
        }
        this.addDefaultEncodingJvmArg(arrayList);
        if (this.assertionsEnabled) {
            arrayList.add("-ea");
        }
        if (this.debug) {
            arrayList.add("-Xdebug");
            arrayList.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
        }
        return arrayList;
    }

    public void setAllJvmArgs(Iterable<?> iterable) {
        this.systemProperties.clear();
        this.minHeapSize = null;
        this.maxHeapSize = null;
        this.extraJvmArgs.clear();
        this.assertionsEnabled = false;
        this.jvmArgs(iterable);
    }

    public List<String> getJvmArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.extraJvmArgs) {
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    public void setJvmArgs(Iterable<?> iterable) {
        this.extraJvmArgs.clear();
        this.jvmArgs(iterable);
    }

    public void jvmArgs(Iterable<?> iterable) {
        Object object;
        for (Object obj : iterable) {
            object = obj.toString();
            Object object2 = DEFAULT_ENCODING_PATTERN.matcher((CharSequence)object);
            if (((Matcher)object2).matches()) {
                this.defaultCharacterEncoding = ((Matcher)object2).group(1);
                continue;
            }
            object2 = SYS_PROP_PATTERN.matcher((CharSequence)object);
            if (((Matcher)object2).matches()) {
                this.systemProperties.put(((Matcher)object2).group(1), ((Matcher)object2).group(2));
                continue;
            }
            object2 = NO_ARG_SYS_PROP_PATTERN.matcher((CharSequence)object);
            if (((Matcher)object2).matches()) {
                this.systemProperties.put(((Matcher)object2).group(1), "");
                continue;
            }
            object2 = MIN_HEAP_PATTERN.matcher((CharSequence)object);
            if (((Matcher)object2).matches()) {
                this.minHeapSize = ((Matcher)object2).group(1);
                continue;
            }
            object2 = MAX_HEAP_PATTERN.matcher((CharSequence)object);
            if (((Matcher)object2).matches()) {
                this.maxHeapSize = ((Matcher)object2).group(1);
                continue;
            }
            object2 = BOOTSTRAP_PATTERN.matcher((CharSequence)object);
            if (((Matcher)object2).matches()) {
                this.setBootstrapClasspath(((Matcher)object2).group(1).split(Pattern.quote(File.pathSeparator)));
                continue;
            }
            if (((String)object).equals("-ea") || ((String)object).equals("-enableassertions")) {
                this.assertionsEnabled = true;
                continue;
            }
            if (((String)object).equals("-da") || ((String)object).equals("-disableassertions")) {
                this.assertionsEnabled = false;
                continue;
            }
            this.extraJvmArgs.add(obj);
        }
        boolean bl = false;
        boolean bl2 = false;
        object = new HashSet();
        for (Object e : this.extraJvmArgs) {
            if (e.toString().equals("-Xdebug")) {
                bl = true;
                object.add(e);
                continue;
            }
            if (!e.toString().equals("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005")) continue;
            bl2 = true;
            object.add(e);
        }
        if (bl && bl2) {
            this.debug = true;
            this.extraJvmArgs.removeAll((Collection<?>)object);
        } else {
            this.debug = false;
        }
    }

    public void jvmArgs(Object ... objectArray) {
        this.jvmArgs(Arrays.asList(objectArray));
    }

    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, ?> map) {
        this.systemProperties.clear();
        this.systemProperties.putAll(map);
    }

    public void systemProperties(Map<String, ?> map) {
        this.systemProperties.putAll(map);
    }

    public void systemProperty(String string, Object object) {
        this.systemProperties.put(string, object);
    }

    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(FileCollection fileCollection) {
        this.bootstrapClasspath.setFrom(fileCollection);
    }

    public void setBootstrapClasspath(Object ... objectArray) {
        this.bootstrapClasspath.setFrom(objectArray);
    }

    public void bootstrapClasspath(Object ... objectArray) {
        this.bootstrapClasspath.from(objectArray);
    }

    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(String string) {
        this.minHeapSize = string;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String string) {
        this.maxHeapSize = string;
    }

    public String getDefaultCharacterEncoding() {
        return this.defaultCharacterEncoding;
    }

    public String getEffectiveDefaultCharacterEncoding() {
        if (this.defaultCharacterEncoding != null) {
            return this.defaultCharacterEncoding;
        }
        return Charset.defaultCharset().name();
    }

    private void addDefaultEncodingJvmArg(List<String> list) {
        list.add(String.format("-Dfile.encoding=%s", this.getEffectiveDefaultCharacterEncoding()));
    }

    public void setDefaultCharacterEncoding(String string) {
        this.defaultCharacterEncoding = string;
    }

    public boolean getEnableAssertions() {
        return this.assertionsEnabled;
    }

    public void setEnableAssertions(boolean bl) {
        this.assertionsEnabled = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void copyTo(JavaForkOptions javaForkOptions) {
        javaForkOptions.setJvmArgs(this.extraJvmArgs);
        javaForkOptions.setSystemProperties(this.systemProperties);
        javaForkOptions.setMinHeapSize(this.minHeapSize);
        javaForkOptions.setMaxHeapSize(this.maxHeapSize);
        javaForkOptions.setBootstrapClasspath(this.bootstrapClasspath);
        javaForkOptions.setEnableAssertions(this.assertionsEnabled);
        javaForkOptions.setDebug(this.debug);
    }

    public static List<String> fromString(String string) {
        return ArgumentsSplitter.split(string);
    }
}

