/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.ExecHandle;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExecHandleBuilder
extends AbstractExecHandleBuilder
implements JavaExecSpec {
    private String mainClass;
    private final List<Object> applicationArgs = new ArrayList<Object>();
    private FileCollection classpath;
    private final JavaForkOptions javaOptions;
    private final FileResolver fileResolver;

    public JavaExecHandleBuilder(FileResolver fileResolver) {
        super(fileResolver);
        this.fileResolver = fileResolver;
        this.javaOptions = new DefaultJavaForkOptions(fileResolver);
        this.classpath = new DefaultConfigurableFileCollection(fileResolver, null, new Object[0]);
        this.executable(this.javaOptions.getExecutable());
    }

    @Override
    public List<String> getAllJvmArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.javaOptions.getAllJvmArgs());
        if (!this.classpath.isEmpty()) {
            arrayList.add("-cp");
            arrayList.add(GUtil.join(this.classpath.getFiles(), File.pathSeparator));
        }
        return arrayList;
    }

    @Override
    public void setAllJvmArgs(Iterable<?> iterable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getJvmArgs() {
        return this.javaOptions.getJvmArgs();
    }

    @Override
    public void setJvmArgs(Iterable<?> iterable) {
        this.javaOptions.setJvmArgs(iterable);
    }

    @Override
    public JavaExecHandleBuilder jvmArgs(Iterable<?> iterable) {
        this.javaOptions.jvmArgs(iterable);
        return this;
    }

    @Override
    public JavaExecHandleBuilder jvmArgs(Object ... objectArray) {
        this.javaOptions.jvmArgs(objectArray);
        return this;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.javaOptions.getSystemProperties();
    }

    @Override
    public void setSystemProperties(Map<String, ?> map) {
        this.javaOptions.setSystemProperties(map);
    }

    @Override
    public JavaExecHandleBuilder systemProperties(Map<String, ?> map) {
        this.javaOptions.systemProperties(map);
        return this;
    }

    @Override
    public JavaExecHandleBuilder systemProperty(String string, Object object) {
        this.javaOptions.systemProperty(string, object);
        return this;
    }

    @Override
    public FileCollection getBootstrapClasspath() {
        return this.javaOptions.getBootstrapClasspath();
    }

    @Override
    public void setBootstrapClasspath(FileCollection fileCollection) {
        this.javaOptions.setBootstrapClasspath(fileCollection);
    }

    @Override
    public JavaForkOptions bootstrapClasspath(Object ... objectArray) {
        this.javaOptions.bootstrapClasspath(objectArray);
        return this;
    }

    @Override
    public String getMinHeapSize() {
        return this.javaOptions.getMinHeapSize();
    }

    @Override
    public void setMinHeapSize(String string) {
        this.javaOptions.setMinHeapSize(string);
    }

    @Override
    public String getDefaultCharacterEncoding() {
        return this.javaOptions.getDefaultCharacterEncoding();
    }

    @Override
    public void setDefaultCharacterEncoding(String string) {
        this.javaOptions.setDefaultCharacterEncoding(string);
    }

    @Override
    public String getMaxHeapSize() {
        return this.javaOptions.getMaxHeapSize();
    }

    @Override
    public void setMaxHeapSize(String string) {
        this.javaOptions.setMaxHeapSize(string);
    }

    @Override
    public boolean getEnableAssertions() {
        return this.javaOptions.getEnableAssertions();
    }

    @Override
    public void setEnableAssertions(boolean bl) {
        this.javaOptions.setEnableAssertions(bl);
    }

    @Override
    public boolean getDebug() {
        return this.javaOptions.getDebug();
    }

    @Override
    public void setDebug(boolean bl) {
        this.javaOptions.setDebug(bl);
    }

    @Override
    public String getMain() {
        return this.mainClass;
    }

    @Override
    public JavaExecHandleBuilder setMain(String string) {
        this.mainClass = string;
        return this;
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.applicationArgs) {
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    @Override
    public JavaExecHandleBuilder setArgs(Iterable<?> iterable) {
        this.applicationArgs.clear();
        GUtil.addToCollection(this.applicationArgs, iterable);
        return this;
    }

    @Override
    public JavaExecHandleBuilder args(Object ... objectArray) {
        this.applicationArgs.addAll(Arrays.asList(objectArray));
        return this;
    }

    @Override
    public JavaExecSpec args(Iterable<?> iterable) {
        GUtil.addToCollection(this.applicationArgs, iterable);
        return this;
    }

    @Override
    public JavaExecHandleBuilder setClasspath(FileCollection fileCollection) {
        this.classpath = fileCollection;
        return this;
    }

    @Override
    public JavaExecHandleBuilder classpath(Object ... objectArray) {
        this.classpath = this.classpath.plus(this.fileResolver.resolveFiles(objectArray));
        return this;
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public List<String> getAllArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getAllJvmArgs());
        arrayList.add(this.mainClass);
        arrayList.addAll(this.getArgs());
        return arrayList;
    }

    @Override
    public JavaForkOptions copyTo(JavaForkOptions javaForkOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecHandle build() {
        if (this.mainClass == null) {
            throw new IllegalStateException("No main class specified");
        }
        return super.build();
    }

    @Override
    public JavaExecSpec setIgnoreExitValue(boolean bl) {
        super.setIgnoreExitValue(bl);
        return this;
    }
}

