/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.CompositeStoppable;

public class ExecOutputHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecOutputHandleRunner.class);
    private final String displayName;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public ExecOutputHandleRunner(String string, InputStream inputStream, OutputStream outputStream) {
        this.displayName = string;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public void run() {
        byte[] byArray = new byte[2048];
        try {
            int n;
            while ((n = this.inputStream.read(byArray)) >= 0) {
                this.outputStream.write(byArray, 0, n);
                this.outputStream.flush();
            }
            new CompositeStoppable(new Object[]{this.inputStream, this.outputStream}).stop();
        }
        catch (Throwable throwable) {
            LOGGER.error(String.format("Could not %s.", this.displayName), throwable);
        }
    }

    public String toString() {
        return this.displayName;
    }
}

