/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.util.concurrent.Executor;
import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.ExecOutputHandleRunner;
import org.gradle.process.internal.ProcessBuilderFactory;
import org.gradle.util.DisconnectableInputStream;

public class ExecHandleRunner
implements Runnable {
    private static final Object START_LOCK = new Object();
    private final ProcessBuilderFactory processBuilderFactory;
    private final DefaultExecHandle execHandle;
    private final Executor threadPool;
    private final Object lock;
    private Process process;
    private boolean aborted;

    public ExecHandleRunner(DefaultExecHandle defaultExecHandle, Executor executor) {
        if (defaultExecHandle == null) {
            throw new IllegalArgumentException("execHandle == null!");
        }
        this.processBuilderFactory = new ProcessBuilderFactory();
        this.execHandle = defaultExecHandle;
        this.lock = new Object();
        this.threadPool = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWaiting() {
        Object object = this.lock;
        synchronized (object) {
            this.aborted = true;
            if (this.process != null) {
                this.process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n;
        ProcessBuilder processBuilder = this.processBuilderFactory.createProcessBuilder(this.execHandle);
        try {
            ExecOutputHandleRunner execOutputHandleRunner;
            ExecOutputHandleRunner execOutputHandleRunner2;
            ExecOutputHandleRunner execOutputHandleRunner3;
            Process process;
            DisconnectableInputStream disconnectableInputStream = new DisconnectableInputStream(this.execHandle.getStandardInput(), new DefaultExecutorFactory());
            Object object = START_LOCK;
            synchronized (object) {
                process = processBuilder.start();
                execOutputHandleRunner3 = new ExecOutputHandleRunner("read process standard output", process.getInputStream(), this.execHandle.getStandardOutput());
                execOutputHandleRunner2 = new ExecOutputHandleRunner("read process error output", process.getErrorStream(), this.execHandle.getErrorOutput());
                execOutputHandleRunner = new ExecOutputHandleRunner("write process standard input", disconnectableInputStream, process.getOutputStream());
            }
            object = this.lock;
            synchronized (object) {
                this.process = process;
            }
            this.threadPool.execute(execOutputHandleRunner);
            this.threadPool.execute(execOutputHandleRunner3);
            this.threadPool.execute(execOutputHandleRunner2);
            this.execHandle.started();
            n = process.waitFor();
            ((InputStream)disconnectableInputStream).close();
        }
        catch (Throwable throwable) {
            this.execHandle.failed(throwable);
            return;
        }
        if (this.aborted) {
            this.execHandle.aborted(n);
        } else {
            this.execHandle.finished(n);
        }
    }
}

