/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecHandleBuilder
extends AbstractExecHandleBuilder
implements ExecSpec {
    private final List<Object> arguments = new ArrayList<Object>();

    public ExecHandleBuilder() {
        super(new IdentityFileResolver());
    }

    public ExecHandleBuilder(FileResolver fileResolver) {
        super(fileResolver);
    }

    @Override
    public ExecHandleBuilder commandLine(Object ... objectArray) {
        this.commandLine(Arrays.asList(objectArray));
        return this;
    }

    @Override
    public ExecSpec commandLine(Iterable<?> iterable) {
        ArrayList arrayList = Lists.newArrayList(iterable);
        this.executable(arrayList.get(0));
        this.setArgs((Iterable)arrayList.subList(1, arrayList.size()));
        return this;
    }

    @Override
    public void setCommandLine(Object ... objectArray) {
        this.commandLine(objectArray);
    }

    @Override
    public void setCommandLine(Iterable<?> iterable) {
        this.commandLine(iterable);
    }

    @Override
    public ExecHandleBuilder args(Object ... objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("args == null!");
        }
        this.arguments.addAll(Arrays.asList(objectArray));
        return this;
    }

    @Override
    public ExecSpec args(Iterable<?> iterable) {
        GUtil.addToCollection(this.arguments, iterable);
        return this;
    }

    @Override
    public ExecHandleBuilder setArgs(Iterable<?> iterable) {
        this.arguments.clear();
        GUtil.addToCollection(this.arguments, iterable);
        return this;
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.arguments) {
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    @Override
    public List<String> getAllArguments() {
        return this.getArgs();
    }

    @Override
    public ExecHandleBuilder setIgnoreExitValue(boolean bl) {
        super.setIgnoreExitValue(bl);
        return this;
    }
}

