/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Factory;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.process.internal.DefaultWorkerProcess;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ApplicationClassesInIsolatedClassLoaderWorkerFactory;
import org.gradle.process.internal.child.ApplicationClassesInSystemClassLoaderWorkerFactory;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.process.internal.launcher.GradleWorkerMain;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.GUtil;
import org.gradle.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessFactory
implements Factory<WorkerProcessBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerProcessFactory.class);
    private final LogLevel workerLogLevel;
    private final MessagingServer server;
    private final ClassPathRegistry classPathRegistry;
    private final FileResolver resolver;
    private final IdGenerator<?> idGenerator;

    public DefaultWorkerProcessFactory(LogLevel logLevel, MessagingServer messagingServer, ClassPathRegistry classPathRegistry, FileResolver fileResolver, IdGenerator<?> idGenerator) {
        this.workerLogLevel = logLevel;
        this.server = messagingServer;
        this.classPathRegistry = classPathRegistry;
        this.resolver = fileResolver;
        this.idGenerator = idGenerator;
    }

    public WorkerProcessBuilder create() {
        return new DefaultWorkerProcessBuilder();
    }

    private class DefaultWorkerProcessBuilder
    extends WorkerProcessBuilder {
        public DefaultWorkerProcessBuilder() {
            super(DefaultWorkerProcessFactory.this.resolver);
            this.setLogLevel(DefaultWorkerProcessFactory.this.workerLogLevel);
            this.getJavaCommand().setMain(GradleWorkerMain.class.getName());
        }

        public WorkerProcess build() {
            if (this.getWorker() == null) {
                throw new IllegalStateException("No worker action specified for this worker process.");
            }
            DefaultWorkerProcess defaultWorkerProcess = new DefaultWorkerProcess(120, TimeUnit.SECONDS);
            Address address = DefaultWorkerProcessFactory.this.server.accept(defaultWorkerProcess.getConnectAction());
            List<URL> list = ClasspathUtil.getClasspath(this.getWorker().getClass().getClassLoader());
            Object t = DefaultWorkerProcessFactory.this.idGenerator.generateId();
            String string = String.format("Gradle Worker %s", t);
            WorkerFactory workerFactory = this.isLoadApplicationInSystemClassLoader() ? new ApplicationClassesInSystemClassLoaderWorkerFactory(t, string, this, list, address, DefaultWorkerProcessFactory.this.classPathRegistry) : new ApplicationClassesInIsolatedClassLoaderWorkerFactory(t, string, this, list, address, DefaultWorkerProcessFactory.this.classPathRegistry);
            LOGGER.debug("Creating {}", (Object)string);
            LOGGER.debug("Using application classpath {}", this.getApplicationClasspath());
            LOGGER.debug("Using implementation classpath {}", list);
            JavaExecHandleBuilder javaExecHandleBuilder = this.getJavaCommand();
            this.attachStdInContent(workerFactory, javaExecHandleBuilder);
            workerFactory.prepareJavaCommand(javaExecHandleBuilder);
            javaExecHandleBuilder.setDisplayName(string);
            ExecHandle execHandle = javaExecHandleBuilder.build();
            defaultWorkerProcess.setExecHandle(execHandle);
            return defaultWorkerProcess;
        }

        private void attachStdInContent(WorkerFactory workerFactory, JavaExecHandleBuilder javaExecHandleBuilder) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(GUtil.serialize(workerFactory.create()));
            javaExecHandleBuilder.setStandardInput(byteArrayInputStream);
        }
    }
}

