/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.WorkerProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcess
implements WorkerProcess {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private ObjectConnection connection;
    private ExecHandle execHandle;
    private boolean running;
    private Throwable processFailure;
    private final long connectTimeout;

    public DefaultWorkerProcess(int n, TimeUnit timeUnit) {
        this.connectTimeout = timeUnit.toMillis(n);
    }

    public void setExecHandle(ExecHandle execHandle) {
        this.execHandle = execHandle;
        execHandle.addListener(new ExecHandleListener(){

            public void executionStarted(ExecHandle execHandle) {
            }

            public void executionFinished(ExecHandle execHandle, ExecResult execResult) {
                DefaultWorkerProcess.this.onProcessStop(execResult);
            }
        });
    }

    public Action<ConnectEvent<ObjectConnection>> getConnectAction() {
        return new Action<ConnectEvent<ObjectConnection>>(){

            @Override
            public void execute(ConnectEvent<ObjectConnection> connectEvent) {
                DefaultWorkerProcess.this.onConnect(connectEvent.getConnection());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnect(ObjectConnection objectConnection) {
        this.lock.lock();
        try {
            this.connection = objectConnection;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProcessStop(ExecResult execResult) {
        this.lock.lock();
        try {
            try {
                execResult.rethrowFailure().assertNormalExitValue();
            }
            catch (Throwable throwable) {
                this.processFailure = throwable;
            }
            this.running = false;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.execHandle.toString();
    }

    @Override
    public ObjectConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.lock.lock();
        try {
            this.running = true;
        }
        finally {
            this.lock.unlock();
        }
        this.execHandle.start();
        Date date = new Date(System.currentTimeMillis() + this.connectTimeout);
        this.lock.lock();
        try {
            while (this.connection == null && this.running) {
                try {
                    if (this.condition.awaitUntil(date)) continue;
                    throw new ExecException(String.format("Timeout waiting for %s to connect.", this.execHandle));
                }
                catch (InterruptedException interruptedException) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)interruptedException);
                }
            }
            if (this.processFailure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.processFailure);
            }
            if (this.connection == null) {
                throw new ExecException(String.format("Never received a connection from %s.", this.execHandle));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResult waitForStop() {
        ObjectConnection objectConnection;
        ExecResult execResult = this.execHandle.waitForFinish();
        this.lock.lock();
        try {
            objectConnection = this.connection;
        }
        finally {
            this.connection = null;
            this.execHandle = null;
            this.lock.unlock();
        }
        if (objectConnection != null) {
            objectConnection.stop();
        }
        return execResult.assertNormalExitValue();
    }
}

