/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileSource;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.ProcessForkOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessForkOptions
implements ProcessForkOptions {
    private final FileResolver resolver;
    private Object executable;
    private FileSource workingDir;
    private final Map<String, Object> environment = new HashMap<String, Object>(Jvm.current().getInheritableEnvironmentVariables(System.getenv()));

    public DefaultProcessForkOptions(FileResolver fileResolver) {
        this.resolver = fileResolver;
        this.workingDir = fileResolver.resolveLater(".");
    }

    protected FileResolver getResolver() {
        return this.resolver;
    }

    @Override
    public String getExecutable() {
        return this.executable == null ? null : this.executable.toString();
    }

    @Override
    public void setExecutable(Object object) {
        this.executable = object;
    }

    @Override
    public ProcessForkOptions executable(Object object) {
        this.setExecutable(object);
        return this;
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir.get();
    }

    @Override
    public void setWorkingDir(Object object) {
        this.workingDir = this.resolver.resolveLater(object);
    }

    @Override
    public ProcessForkOptions workingDir(Object object) {
        this.setWorkingDir(object);
        return this;
    }

    @Override
    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getActualEnvironment() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.environment.entrySet()) {
            hashMap.put(entry.getKey(), String.valueOf(entry.getValue().toString()));
        }
        return hashMap;
    }

    @Override
    public void setEnvironment(Map<String, ?> map) {
        this.environment.clear();
        this.environment.putAll(map);
    }

    @Override
    public ProcessForkOptions environment(String string, Object object) {
        this.environment.put(string, object);
        return this;
    }

    @Override
    public ProcessForkOptions environment(Map<String, ?> map) {
        this.environment.putAll(map);
        return this;
    }

    @Override
    public ProcessForkOptions copyTo(ProcessForkOptions processForkOptions) {
        processForkOptions.setExecutable(this.executable);
        processForkOptions.setWorkingDir(this.workingDir);
        processForkOptions.setEnvironment(this.environment);
        return this;
    }
}

