/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.listener.AsyncListenerBroadcast;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.ExecHandleRunner;
import org.gradle.process.internal.ExecHandleShutdownHookAction;
import org.gradle.process.internal.ExecHandleState;
import org.gradle.process.internal.ProcessParentingInitializer;
import org.gradle.process.internal.shutdown.ShutdownHookActionRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecHandle
implements ExecHandle {
    private static final Logger LOGGER = Logging.getLogger(DefaultExecHandle.class);
    private final String displayName;
    private final File directory;
    private final String command;
    private final List<String> arguments;
    private final Map<String, String> environment;
    private final OutputStream standardOutput;
    private final OutputStream errorOutput;
    private final InputStream standardInput;
    private final Lock lock;
    private final Condition stateChange;
    private final StoppableExecutor executor;
    private ExecHandleState state;
    private ExecHandleRunner execHandleRunner;
    private ExecResultImpl execResult;
    private final ListenerBroadcast<ExecHandleListener> broadcast;
    private final ExecHandleShutdownHookAction shutdownHookAction;

    DefaultExecHandle(String string, File file, String string2, List<String> list, Map<String, String> map, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, List<ExecHandleListener> list2) {
        this.displayName = string;
        this.directory = file;
        this.command = string2;
        this.arguments = list;
        this.environment = map;
        this.standardOutput = outputStream;
        this.errorOutput = outputStream2;
        this.standardInput = inputStream;
        this.lock = new ReentrantLock();
        this.stateChange = this.lock.newCondition();
        this.state = ExecHandleState.INIT;
        this.executor = new DefaultExecutorFactory().create(String.format("Run %s", string));
        this.shutdownHookAction = new ExecHandleShutdownHookAction(this);
        this.broadcast = new AsyncListenerBroadcast<ExecHandleListener>(ExecHandleListener.class, this.executor);
        this.broadcast.addAll(list2);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    public InputStream getStandardInput() {
        return this.standardInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecHandleState getState() {
        this.lock.lock();
        try {
            ExecHandleState execHandleState = this.state;
            return execHandleState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ExecHandleState execHandleState) {
        this.lock.lock();
        try {
            this.state = execHandleState;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stateIn(ExecHandleState ... execHandleStateArray) {
        this.lock.lock();
        try {
            boolean bl = Arrays.asList(execHandleStateArray).contains((Object)this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEndStateInfo(ExecHandleState execHandleState, int n, Throwable throwable) {
        ExecResultImpl execResultImpl;
        ShutdownHookActionRegister.removeAction(this.shutdownHookAction);
        this.lock.lock();
        try {
            ExecException execException = null;
            if (throwable != null) {
                execException = this.state == ExecHandleState.STARTING ? new ExecException(String.format("A problem occurred starting %s.", this.displayName), throwable) : new ExecException(String.format("A problem occurred waiting for %s to complete.", this.displayName), throwable);
            }
            this.setState(execHandleState);
            execResultImpl = this.execResult = new ExecResultImpl(n, execException);
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.debug("Process finished (code: {}) for {}.", n, this.displayName);
        this.broadcast.getSource().executionFinished(this, execResultImpl);
        this.broadcast.stop();
        this.executor.requestStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecHandle start() {
        ProcessParentingInitializer.intitialize();
        this.lock.lock();
        try {
            if (!this.stateIn(ExecHandleState.INIT)) {
                throw new IllegalStateException("already started!");
            }
            this.setState(ExecHandleState.STARTING);
            this.execResult = null;
            this.execHandleRunner = new ExecHandleRunner(this, this.executor);
            this.executor.execute(this.execHandleRunner);
            while (this.getState() == ExecHandleState.STARTING) {
                try {
                    this.stateChange.await();
                }
                catch (InterruptedException interruptedException) {
                    throw new UncheckedException((Throwable)interruptedException);
                }
            }
            if (this.execResult != null) {
                this.execResult.rethrowFailure();
            }
            LOGGER.debug("Started {}.", this.displayName);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.lock.lock();
        try {
            if (this.state == ExecHandleState.SUCCEEDED) {
                return;
            }
            if (!this.stateIn(ExecHandleState.STARTED)) {
                throw new IllegalStateException("not in started state!");
            }
            this.execHandleRunner.stopWaiting();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResult waitForFinish() {
        this.executor.stop();
        this.lock.lock();
        try {
            this.execResult.rethrowFailure();
            ExecResultImpl execResultImpl = this.execResult;
            return execResultImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void started() {
        ShutdownHookActionRegister.addAction(this.shutdownHookAction);
        this.setState(ExecHandleState.STARTED);
        this.broadcast.getSource().executionStarted(this);
    }

    void finished(int n) {
        if (n != 0) {
            this.setEndStateInfo(ExecHandleState.FAILED, n, null);
        } else {
            this.setEndStateInfo(ExecHandleState.SUCCEEDED, 0, null);
        }
    }

    void aborted(int n) {
        if (n == 0) {
            n = -1;
        }
        this.setEndStateInfo(ExecHandleState.ABORTED, n, null);
    }

    void failed(Throwable throwable) {
        this.setEndStateInfo(ExecHandleState.FAILED, -1, throwable);
    }

    @Override
    public void addListener(ExecHandleListener execHandleListener) {
        this.broadcast.add(execHandleListener);
    }

    @Override
    public void removeListener(ExecHandleListener execHandleListener) {
        this.broadcast.remove(execHandleListener);
    }

    private class ExecResultImpl
    implements ExecResult {
        private final int exitValue;
        private final ExecException failure;

        public ExecResultImpl(int n, ExecException execException) {
            this.exitValue = n;
            this.failure = execException;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public ExecResult assertNormalExitValue() throws ExecException {
            if (this.exitValue != 0) {
                throw new ExecException(String.format("%s finished with (non-zero) exit value %d.", StringUtils.capitalize((String)DefaultExecHandle.this.displayName), this.exitValue));
            }
            return this;
        }

        public ExecResult rethrowFailure() throws ExecException {
            if (this.failure != null) {
                throw this.failure;
            }
            return this;
        }
    }
}

