/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecHandleBuilder
extends DefaultProcessForkOptions
implements BaseExecSpec {
    private OutputStream standardOutput;
    private OutputStream errorOutput;
    private InputStream input = new ByteArrayInputStream(new byte[0]);
    private String displayName;
    private final List<ExecHandleListener> listeners = new ArrayList<ExecHandleListener>();
    boolean ignoreExitValue;

    public AbstractExecHandleBuilder(FileResolver fileResolver) {
        super(fileResolver);
        this.standardOutput = new CloseShieldOutputStream((OutputStream)System.out);
        this.errorOutput = new CloseShieldOutputStream((OutputStream)System.err);
    }

    public abstract List<String> getAllArguments();

    @Override
    public List<String> getCommandLine() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getExecutable());
        arrayList.addAll(this.getAllArguments());
        return arrayList;
    }

    @Override
    public AbstractExecHandleBuilder setStandardInput(InputStream inputStream) {
        this.input = inputStream;
        return this;
    }

    @Override
    public InputStream getStandardInput() {
        return this.input;
    }

    @Override
    public AbstractExecHandleBuilder setStandardOutput(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream == null!");
        }
        this.standardOutput = outputStream;
        return this;
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    @Override
    public AbstractExecHandleBuilder setErrorOutput(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream == null!");
        }
        this.errorOutput = outputStream;
        return this;
    }

    @Override
    public OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    @Override
    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    @Override
    public BaseExecSpec setIgnoreExitValue(boolean bl) {
        this.ignoreExitValue = bl;
        return this;
    }

    public String getDisplayName() {
        return this.displayName == null ? String.format("command '%s'", this.getExecutable()) : this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public AbstractExecHandleBuilder listener(ExecHandleListener execHandleListener) {
        if (this.listeners == null) {
            throw new IllegalArgumentException("listeners == null!");
        }
        this.listeners.add(execHandleListener);
        return this;
    }

    public ExecHandle build() {
        String string = this.getExecutable();
        if (StringUtils.isEmpty((String)string)) {
            throw new IllegalStateException("execCommand == null!");
        }
        return new DefaultExecHandle(this.getDisplayName(), this.getWorkingDir(), string, this.getAllArguments(), this.getActualEnvironment(), this.standardOutput, this.errorOutput, this.input, this.listeners);
    }
}

