/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.protocol;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.gradle.internal.UncheckedException;
import org.gradle.messaging.remote.internal.Message;

public class MethodMetaInfo
extends Message {
    private final Type type;
    private final String methodName;
    private final Type[] paramTypes;
    private final Object key;

    public MethodMetaInfo(Object object, Method method) {
        this.key = object;
        this.type = new Type(method.getDeclaringClass());
        this.methodName = method.getName();
        this.paramTypes = new Type[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> clazz = method.getParameterTypes()[i];
            this.paramTypes[i] = new Type(clazz);
        }
    }

    public Object getKey() {
        return this.key;
    }

    public Method findMethod(ClassLoader classLoader) {
        try {
            Class<?> clazz = this.type.load(classLoader);
            Class[] classArray = new Class[this.paramTypes.length];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                Type type = this.paramTypes[i];
                classArray[i] = type.load(classLoader);
            }
            return clazz.getMethod(this.methodName, classArray);
        }
        catch (Exception exception) {
            throw UncheckedException.throwAsUncheckedException((Throwable)exception);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        MethodMetaInfo methodMetaInfo = (MethodMetaInfo)object;
        if (!this.key.equals(methodMetaInfo.key)) {
            return false;
        }
        if (!this.type.equals(methodMetaInfo.type)) {
            return false;
        }
        if (!this.methodName.equals(methodMetaInfo.methodName)) {
            return false;
        }
        return Arrays.equals(this.paramTypes, methodMetaInfo.paramTypes);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Type
    implements Serializable {
        private String typeName;
        private Class<?> type;

        public Type(Class<?> clazz) {
            this.typeName = clazz.getName();
            if (clazz.isPrimitive()) {
                this.type = clazz;
            }
        }

        Class<?> load(ClassLoader classLoader) throws ClassNotFoundException {
            if (this.type != null) {
                return this.type;
            }
            return classLoader.loadClass(this.typeName);
        }

        public boolean equals(Object object) {
            return ((Type)object).typeName.equals(this.typeName);
        }

        public int hashCode() {
            return this.typeName.hashCode();
        }
    }
}

